/*
 * Decompiled with CFR 0.152.
 */
package net.kencochrane.raven.connection;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import net.kencochrane.raven.connection.AbstractConnection;
import net.kencochrane.raven.connection.ConnectionException;
import net.kencochrane.raven.environment.RavenEnvironment;
import net.kencochrane.raven.event.Event;
import net.kencochrane.raven.marshaller.Marshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnection
extends AbstractConnection {
    private static final Logger logger = LoggerFactory.getLogger(HttpConnection.class);
    private static final String USER_AGENT = "User-Agent";
    private static final String SENTRY_AUTH = "X-Sentry-Auth";
    private static final int DEFAULT_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(1L);
    private static final HostnameVerifier NAIVE_VERIFIER = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession sslSession) {
            return true;
        }
    };
    private final URL sentryUrl;
    private Marshaller marshaller;
    private int timeout = DEFAULT_TIMEOUT;
    private boolean bypassSecurity = false;

    public HttpConnection(URL sentryUrl, String publicKey, String secretKey) {
        super(publicKey, secretKey);
        this.sentryUrl = sentryUrl;
    }

    public static URL getSentryApiUrl(URI sentryUri, String projectId) {
        try {
            String url = sentryUri.toString() + "api/" + projectId + "/store/";
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Couldn't build a valid URL from the Sentry API.", e);
        }
    }

    protected HttpURLConnection getConnection() {
        try {
            HttpURLConnection connection = (HttpURLConnection)this.sentryUrl.openConnection();
            if (this.bypassSecurity && connection instanceof HttpsURLConnection) {
                ((HttpsURLConnection)connection).setHostnameVerifier(NAIVE_VERIFIER);
            }
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setConnectTimeout(this.timeout);
            connection.setRequestProperty(USER_AGENT, RavenEnvironment.NAME);
            connection.setRequestProperty(SENTRY_AUTH, this.getAuthHeader());
            return connection;
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't set up a connection to the sentry server.", e);
        }
    }

    @Override
    protected void doSend(Event event) {
        HttpURLConnection connection = this.getConnection();
        try {
            connection.connect();
            OutputStream outputStream = connection.getOutputStream();
            this.marshaller.marshall(event, outputStream);
            outputStream.close();
            connection.getInputStream().close();
        }
        catch (IOException e) {
            String errorMessage = connection.getErrorStream() != null ? this.getErrorMessageFromStream(connection.getErrorStream()) : "An exception occurred while submitting the event to the sentry server.";
            throw new ConnectionException(errorMessage, e);
        }
        finally {
            connection.disconnect();
        }
    }

    private String getErrorMessageFromStream(InputStream errorStream) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(errorStream, Charsets.UTF_8));
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        catch (Exception e2) {
            logger.error("Exception while reading the error message from the connection.", e2);
        }
        return sb.toString();
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public void setBypassSecurity(boolean bypassSecurity) {
        this.bypassSecurity = bypassSecurity;
    }

    @Override
    public void close() throws IOException {
    }
}

