/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client;

import com.google.common.io.ByteStreams;
import com.spotify.docker.client.LogMessage;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogReader
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(LogReader.class);
    private final InputStream stream;
    public static final int HEADER_SIZE = 8;
    public static final int FRAME_SIZE_OFFSET = 4;
    private volatile boolean closed;

    public LogReader(InputStream stream) {
        this.stream = stream;
    }

    public LogMessage nextMessage() throws IOException {
        byte[] headerBytes = new byte[8];
        int n = ByteStreams.read(this.stream, headerBytes, 0, 8);
        if (n == 0) {
            return null;
        }
        if (n != 8) {
            throw new EOFException();
        }
        ByteBuffer header = ByteBuffer.wrap(headerBytes);
        byte streamId = header.get();
        header.position(4);
        int frameSize = header.getInt();
        byte[] frame = new byte[frameSize];
        ByteStreams.readFully(this.stream, frame);
        return new LogMessage(streamId, ByteBuffer.wrap(frame));
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.closed) {
            log.warn(this + " not closed properly");
            this.close();
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        ByteStreams.copy(this.stream, ByteStreams.nullOutputStream());
    }
}

