/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.multipart;

import com.ning.http.multipart.FilePartSource;
import com.ning.http.multipart.MultipartEncodingUtil;
import com.ning.http.multipart.PartBase;
import com.ning.http.multipart.PartSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FilePart
extends PartBase {
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    public static final String DEFAULT_TRANSFER_ENCODING = "binary";
    protected static final String FILE_NAME = "; filename=";
    private static final byte[] FILE_NAME_BYTES = MultipartEncodingUtil.getAsciiBytes("; filename=");
    private final PartSource source;
    private long _stalledTime = -1L;

    public FilePart(String name, PartSource partSource, String contentType, String charset, String contentId) {
        super(name, contentType == null ? DEFAULT_CONTENT_TYPE : contentType, charset, DEFAULT_TRANSFER_ENCODING, contentId);
        if (partSource == null) {
            throw new NullPointerException("parSource");
        }
        this.source = partSource;
    }

    public FilePart(String name, PartSource partSource, String contentType, String charset) {
        this(name, partSource, contentType, charset, null);
    }

    public FilePart(String name, PartSource partSource) {
        this(name, partSource, null, null);
    }

    public FilePart(String name, File file) throws FileNotFoundException {
        this(name, new FilePartSource(file), null, null);
    }

    public FilePart(String name, File file, String contentType, String charset) throws FileNotFoundException {
        this(name, new FilePartSource(file), contentType, charset);
    }

    public FilePart(String name, String fileName, File file) throws FileNotFoundException {
        this(name, new FilePartSource(fileName, file), null, null);
    }

    public FilePart(String name, String fileName, File file, String contentType, String charset) throws FileNotFoundException {
        this(name, new FilePartSource(fileName, file), contentType, charset);
    }

    protected void sendDispositionHeader(OutputStream out) throws IOException {
        String filename = this.source.getFileName();
        super.sendDispositionHeader(out);
        if (filename != null) {
            out.write(FILE_NAME_BYTES);
            out.write(QUOTE_BYTES);
            out.write(MultipartEncodingUtil.getAsciiBytes(filename));
            out.write(QUOTE_BYTES);
        }
    }

    protected long dispositionHeaderLength() {
        String filename = this.source.getFileName();
        long length = super.dispositionHeaderLength();
        if (filename != null) {
            length += (long)FILE_NAME_BYTES.length;
            length += (long)QUOTE_BYTES.length;
            length += (long)MultipartEncodingUtil.getAsciiBytes(filename).length;
            length += (long)QUOTE_BYTES.length;
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendData(OutputStream out) throws IOException {
        if (this.lengthOfData() == 0L) {
            return;
        }
        byte[] tmp = new byte[4096];
        InputStream instream = this.source.createInputStream();
        try {
            int len;
            while ((len = instream.read(tmp)) >= 0) {
                out.write(tmp, 0, len);
            }
        }
        finally {
            instream.close();
        }
    }

    public void setStalledTime(long ms) {
        this._stalledTime = ms;
    }

    public long getStalledTime() {
        return this._stalledTime;
    }

    public PartSource getSource() {
        return this.source;
    }

    protected long lengthOfData() {
        return this.source.getLength();
    }
}

