/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.runner.base.config;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.hubspot.singularity.runner.base.config.SingularityRunnerConfigurationProvider;
import com.hubspot.singularity.runner.base.configuration.BaseRunnerConfiguration;
import com.hubspot.singularity.runner.base.configuration.Configuration;

public class ConfigurationBinder {
    private final Binder binder;
    private final Multibinder<BaseRunnerConfiguration> multibinder;

    public static <T extends BaseRunnerConfiguration> ConfigurationBinder newBinder(Binder binder) {
        return new ConfigurationBinder(binder);
    }

    private ConfigurationBinder(Binder binder) {
        this.binder = binder;
        this.multibinder = Multibinder.newSetBinder(binder, BaseRunnerConfiguration.class);
    }

    public <T extends BaseRunnerConfiguration> ConfigurationBinder bindPrimaryConfiguration(Class<T> configurationClass, Optional<String> filename) {
        this.bindConfiguration(configurationClass, filename);
        this.binder.bind(BaseRunnerConfiguration.class).to(configurationClass);
        return this;
    }

    public <T extends BaseRunnerConfiguration> ConfigurationBinder bindConfiguration(Class<T> configurationClass, Optional<String> filename) {
        Preconditions.checkNotNull(configurationClass, "configurationClass");
        Preconditions.checkState(configurationClass.getAnnotation(Configuration.class) != null, "%s must be annotated with @Configuration", configurationClass.getSimpleName());
        this.binder.bind(configurationClass).toProvider(new SingularityRunnerConfigurationProvider<T>(configurationClass, filename)).in(Scopes.SINGLETON);
        this.multibinder.addBinding().to(configurationClass);
        return this;
    }
}

