/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.primitives.Longs;
import com.hubspot.singularity.SingularityShellCommand;
import com.hubspot.singularity.SingularityTaskId;
import com.hubspot.singularity.SingularityTaskShellCommandRequestId;

public class SingularityTaskShellCommandRequest
implements Comparable<SingularityTaskShellCommandRequest> {
    private final SingularityTaskId taskId;
    private final Optional<String> user;
    private final SingularityShellCommand shellCommand;
    private final long timestamp;
    private final SingularityTaskShellCommandRequestId id;

    @JsonCreator
    public SingularityTaskShellCommandRequest(@JsonProperty(value="taskId") SingularityTaskId taskId, @JsonProperty(value="user") Optional<String> user, @JsonProperty(value="timestamp") long timestamp, @JsonProperty(value="shellCommand") SingularityShellCommand shellCommand) {
        this.taskId = taskId;
        this.user = user;
        this.timestamp = timestamp;
        this.shellCommand = shellCommand;
        this.id = new SingularityTaskShellCommandRequestId(taskId, shellCommand.getName(), timestamp);
    }

    @JsonIgnore
    public SingularityTaskShellCommandRequestId getId() {
        return this.id;
    }

    @Override
    public int compareTo(SingularityTaskShellCommandRequest o) {
        return Longs.compare(o.getTimestamp(), this.timestamp);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SingularityTaskShellCommandRequest other = (SingularityTaskShellCommandRequest)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public SingularityTaskId getTaskId() {
        return this.taskId;
    }

    public Optional<String> getUser() {
        return this.user;
    }

    public SingularityShellCommand getShellCommand() {
        return this.shellCommand;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return "SingularityTaskShellCommandRequest [taskId=" + this.taskId + ", user=" + this.user + ", shellCommand=" + this.shellCommand + ", timestamp=" + this.timestamp + "]";
    }
}

