/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.hubspot.singularity.MetadataLevel;
import com.hubspot.singularity.SingularityTaskId;
import com.hubspot.singularity.SingularityTaskIdHolder;

public class SingularityTaskMetadata
extends SingularityTaskIdHolder
implements Comparable<SingularityTaskMetadata> {
    private static final MetadataLevel DEFAULT_METADATA_LEVEL = MetadataLevel.INFO;
    private final long timestamp;
    private final String type;
    private final String title;
    private final MetadataLevel level;
    private final Optional<String> message;
    private final Optional<String> user;

    @JsonCreator
    public SingularityTaskMetadata(@JsonProperty(value="taskId") SingularityTaskId taskId, @JsonProperty(value="timestamp") long timestamp, @JsonProperty(value="type") String type, @JsonProperty(value="title") String title, @JsonProperty(value="message") Optional<String> message, @JsonProperty(value="user") Optional<String> user, @JsonProperty(value="level") Optional<MetadataLevel> level) {
        super(taskId);
        Preconditions.checkNotNull(type);
        Preconditions.checkState(!type.contains("/"));
        this.timestamp = timestamp;
        this.type = type;
        this.title = title;
        this.message = message;
        this.user = user;
        this.level = level.or(DEFAULT_METADATA_LEVEL);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    public Optional<String> getMessage() {
        return this.message;
    }

    public Optional<String> getUser() {
        return this.user;
    }

    public MetadataLevel getLevel() {
        return this.level;
    }

    @Override
    public int compareTo(SingularityTaskMetadata o) {
        return ComparisonChain.start().compare(this.timestamp, o.getTimestamp()).compare((Comparable<?>)((Object)this.type), (Comparable<?>)((Object)o.getType())).compare((Comparable<?>)((Object)this.level), (Comparable<?>)((Object)o.getLevel())).compare((Comparable<?>)((Object)this.getTaskId().getId()), (Comparable<?>)((Object)o.getTaskId().getId())).result();
    }

    public int hashCode() {
        return Objects.hashCode(this.user, this.type, this.title, this.message, this.timestamp, this.getTaskId());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        SingularityTaskMetadata that = (SingularityTaskMetadata)other;
        return Objects.equal(this.user, that.user) && Objects.equal(this.type, that.type) && Objects.equal(this.title, that.title) && Objects.equal(this.message, that.message) && Objects.equal(this.timestamp, that.timestamp) && Objects.equal(this.getTaskId(), that.getTaskId()) && Objects.equal((Object)this.level, (Object)that.level);
    }

    public String toString() {
        return "SingularityTaskMetadata [timestamp=" + this.timestamp + ", type=" + this.type + ", title=" + this.title + ", message=" + this.message + ", user=" + this.user + ", taskId=" + this.getTaskId() + ", level=" + (Object)((Object)this.getLevel()) + "]";
    }
}

