/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.hubspot.mesos.JavaUtils;
import com.hubspot.singularity.InvalidSingularityTaskIdException;
import com.hubspot.singularity.SingularityHistoryItem;
import com.hubspot.singularity.SingularityId;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;

public class SingularityTaskId
extends SingularityId
implements SingularityHistoryItem {
    private final String requestId;
    private final String deployId;
    private final long startedAt;
    private final int instanceNo;
    private final String sanitizedHost;
    private final String sanitizedRackId;
    public static Function<SingularityTaskId, String> TASK_ID_TO_REQUEST_ID = new Function<SingularityTaskId, String>(){

        @Override
        public String apply(@Nonnull SingularityTaskId input) {
            return input.getRequestId();
        }
    };
    public static Comparator<SingularityTaskId> INSTANCE_NO_COMPARATOR = new Comparator<SingularityTaskId>(){

        @Override
        public int compare(SingularityTaskId o1, SingularityTaskId o2) {
            return Integer.compare(o1.instanceNo, o2.instanceNo);
        }
    };
    public static Comparator<SingularityTaskId> STARTED_AT_COMPARATOR_DESC = new Comparator<SingularityTaskId>(){

        @Override
        public int compare(SingularityTaskId o1, SingularityTaskId o2) {
            return Long.compare(o2.startedAt, o1.startedAt);
        }
    };

    public static Predicate<SingularityTaskId> matchingRequest(final String requestId) {
        return new Predicate<SingularityTaskId>(){

            @Override
            public boolean apply(@Nonnull SingularityTaskId input) {
                return input.getRequestId().equals(requestId);
            }
        };
    }

    public static Predicate<SingularityTaskId> matchingDeploy(final String deployId) {
        return new Predicate<SingularityTaskId>(){

            @Override
            public boolean apply(@Nonnull SingularityTaskId input) {
                return input.getDeployId().equals(deployId);
            }
        };
    }

    public static Predicate<SingularityTaskId> notIn(Collection<SingularityTaskId> exclude) {
        return Predicates.not(Predicates.in(exclude));
    }

    public static List<SingularityTaskId> matchingAndNotIn(Collection<SingularityTaskId> taskIds, String requestId, String deployId, Collection<SingularityTaskId> exclude) {
        return Lists.newArrayList(Iterables.filter(taskIds, Predicates.and(SingularityTaskId.matchingRequest(requestId), SingularityTaskId.matchingDeploy(deployId), SingularityTaskId.notIn(exclude))));
    }

    public static List<SingularityTaskId> matchingAndNotIn(Collection<SingularityTaskId> taskIds, String requestId, Collection<SingularityTaskId> exclude) {
        return Lists.newArrayList(Iterables.filter(taskIds, Predicates.and(SingularityTaskId.matchingRequest(requestId), SingularityTaskId.notIn(exclude))));
    }

    public SingularityTaskId(String requestId, String deployId, long startedAt, int instanceNo, String sanitizedHost, String sanitizedRackId) {
        this.requestId = requestId;
        this.deployId = deployId;
        this.startedAt = startedAt;
        this.instanceNo = instanceNo;
        this.sanitizedHost = sanitizedHost;
        this.sanitizedRackId = sanitizedRackId;
    }

    @JsonCreator
    public SingularityTaskId(@JsonProperty(value="requestId") String requestId, @JsonProperty(value="deployId") String deployId, @JsonProperty(value="nextRunAt") Long nextRunAt, @JsonProperty(value="startedAt") Long startedAt, @JsonProperty(value="instanceNo") int instanceNo, @JsonProperty(value="host") String host, @JsonProperty(value="sanitizedHost") String sanitizedHost, @JsonProperty(value="sanitizedRackId") String sanitizedRackId, @JsonProperty(value="rackId") String rackId) {
        this(requestId, deployId, Objects.firstNonNull(startedAt, nextRunAt), instanceNo, Objects.firstNonNull(sanitizedHost, host), Objects.firstNonNull(sanitizedRackId, rackId));
    }

    public String getRackId() {
        return this.getSanitizedRackId();
    }

    public String getSanitizedRackId() {
        return this.sanitizedRackId;
    }

    @JsonIgnore
    public boolean matchesOriginalRackId(String unsanitizedRackId) {
        return this.sanitizedRackId.equals(JavaUtils.getReplaceHyphensWithUnderscores(unsanitizedRackId));
    }

    public String getDeployId() {
        return this.deployId;
    }

    public String getHost() {
        return this.getSanitizedHost();
    }

    public String getSanitizedHost() {
        return this.sanitizedHost;
    }

    @JsonIgnore
    public boolean matchesOriginalHost(String unsanitizedHost) {
        return this.sanitizedHost.equals(JavaUtils.getReplaceHyphensWithUnderscores(unsanitizedHost));
    }

    public String getRequestId() {
        return this.requestId;
    }

    public long getStartedAt() {
        return this.startedAt;
    }

    public int getInstanceNo() {
        return this.instanceNo;
    }

    @Override
    @JsonIgnore
    public long getCreateTimestampForCalculatingHistoryAge() {
        return this.getStartedAt();
    }

    public static SingularityTaskId valueOf(String string) throws InvalidSingularityTaskIdException {
        String[] splits = null;
        try {
            splits = JavaUtils.reverseSplit(string, 6, "-");
        }
        catch (IllegalStateException ise) {
            throw new InvalidSingularityTaskIdException(String.format("TaskId %s was invalid (%s)", string, ise.getMessage()));
        }
        try {
            String requestId = splits[0];
            String deployId = splits[1];
            long startedAt = Long.parseLong(splits[2]);
            int instanceNo = Integer.parseInt(splits[3]);
            String host = splits[4];
            String rackId = splits[5];
            return new SingularityTaskId(requestId, deployId, startedAt, instanceNo, host, rackId);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidSingularityTaskIdException(String.format("TaskId %s had an invalid parameter (%s)", string, e.getMessage()));
        }
    }

    @Override
    public String getId() {
        return String.format("%s-%s-%s-%s-%s-%s", this.getRequestId(), this.getDeployId(), this.getStartedAt(), this.getInstanceNo(), this.getSanitizedHost(), this.getSanitizedRackId());
    }

    public String toString() {
        return this.getId();
    }
}

