/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.ComparisonChain;
import com.hubspot.mesos.JavaUtils;
import com.hubspot.singularity.SingularityTaskId;
import com.hubspot.singularity.SingularityTaskIdHolder;

public class SingularityTaskHealthcheckResult
extends SingularityTaskIdHolder
implements Comparable<SingularityTaskHealthcheckResult> {
    private final Optional<Integer> statusCode;
    private final Optional<Long> durationMillis;
    private final Optional<String> responseBody;
    private final Optional<String> errorMessage;
    private final long timestamp;

    @JsonCreator
    public SingularityTaskHealthcheckResult(@JsonProperty(value="statusCode") Optional<Integer> statusCode, @JsonProperty(value="duration") Optional<Long> durationMillis, @JsonProperty(value="timestamp") long timestamp, @JsonProperty(value="responseBody") Optional<String> responseBody, @JsonProperty(value="errorMessage") Optional<String> errorMessage, @JsonProperty(value="taskId") SingularityTaskId taskId) {
        super(taskId);
        this.statusCode = statusCode;
        this.errorMessage = errorMessage;
        this.durationMillis = durationMillis;
        this.timestamp = timestamp;
        this.responseBody = responseBody;
    }

    @Override
    public int compareTo(SingularityTaskHealthcheckResult o) {
        return ComparisonChain.start().compare(this.timestamp, o.getTimestamp()).compare((Comparable<?>)((Object)o.getTaskId().getId()), (Comparable<?>)((Object)this.getTaskId().getId())).result();
    }

    public int hashCode() {
        return Objects.hashCode(this.getTaskId(), this.statusCode, this.durationMillis, this.responseBody, this.errorMessage, this.timestamp);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        SingularityTaskHealthcheckResult that = (SingularityTaskHealthcheckResult)other;
        return Objects.equal(this.statusCode, that.statusCode) && Objects.equal(this.getTaskId(), that.getTaskId()) && Objects.equal(this.durationMillis, that.durationMillis) && Objects.equal(this.responseBody, that.responseBody) && Objects.equal(this.errorMessage, that.errorMessage) && Objects.equal(this.timestamp, that.timestamp);
    }

    public Optional<Integer> getStatusCode() {
        return this.statusCode;
    }

    public Optional<Long> getDurationMillis() {
        return this.durationMillis;
    }

    public Optional<String> getErrorMessage() {
        return this.errorMessage;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Optional<String> getResponseBody() {
        return this.responseBody;
    }

    @JsonIgnore
    public boolean isFailed() {
        return this.getErrorMessage().isPresent() || this.getStatusCode().isPresent() && !JavaUtils.isHttpSuccess(this.getStatusCode().get());
    }

    public String toString() {
        return "SingularityTaskHealthcheckResult [statusCode=" + this.statusCode + ", durationMillis=" + this.durationMillis + ", timestamp=" + this.timestamp + ", responseBody=" + this.responseBody + ", errorMessage=" + this.errorMessage + ", taskId=" + this.getTaskId() + "]";
    }
}

