/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.ComparisonChain;
import com.hubspot.singularity.SingularityHistoryItem;
import com.hubspot.singularity.SingularityRequest;

public class SingularityRequestHistory
implements Comparable<SingularityRequestHistory>,
SingularityHistoryItem {
    private final long createdAt;
    private final Optional<String> user;
    private final RequestHistoryType eventType;
    private final SingularityRequest request;
    private final Optional<String> message;

    @JsonCreator
    public SingularityRequestHistory(@JsonProperty(value="createdAt") long createdAt, @JsonProperty(value="user") Optional<String> user, @JsonProperty(value="eventType") RequestHistoryType eventType, @JsonProperty(value="request") SingularityRequest request, @JsonProperty(value="message") Optional<String> message) {
        this.createdAt = createdAt;
        this.user = user;
        this.eventType = eventType;
        this.request = request;
        this.message = message;
    }

    @Override
    public int compareTo(SingularityRequestHistory o) {
        return ComparisonChain.start().compare(o.getCreatedAt(), this.createdAt).compare((Comparable<?>)((Object)this.request.getId()), (Comparable<?>)((Object)o.getRequest().getId())).result();
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.createdAt, this.user, this.eventType, this.request, this.message});
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        SingularityRequestHistory that = (SingularityRequestHistory)other;
        return Objects.equal(this.createdAt, that.createdAt) && Objects.equal(this.user, that.user) && Objects.equal((Object)this.eventType, (Object)that.eventType) && Objects.equal(this.request, that.request) && Objects.equal(this.message, that.message);
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public Optional<String> getUser() {
        return this.user;
    }

    @Deprecated
    @JsonIgnore
    public RequestHistoryType getState() {
        return this.eventType;
    }

    public RequestHistoryType getEventType() {
        return this.eventType;
    }

    public SingularityRequest getRequest() {
        return this.request;
    }

    public Optional<String> getMessage() {
        return this.message;
    }

    @Override
    @JsonIgnore
    public long getCreateTimestampForCalculatingHistoryAge() {
        return this.createdAt;
    }

    public String toString() {
        return "SingularityRequestHistory [createdAt=" + this.createdAt + ", user=" + this.user + ", eventType=" + (Object)((Object)this.eventType) + ", request=" + this.request + ", message=" + this.message + "]";
    }

    public static enum RequestHistoryType {
        CREATED,
        UPDATED,
        DELETED,
        PAUSED,
        UNPAUSED,
        ENTERED_COOLDOWN,
        EXITED_COOLDOWN,
        FINISHED,
        DEPLOYED_TO_UNPAUSE,
        BOUNCED,
        SCALED,
        SCALE_REVERTED;

    }
}

