/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.singularity.SingularityTaskId;
import java.util.Set;

public class SingularityDeployProgress {
    private final int targetActiveInstances;
    private final int deployInstanceCountPerStep;
    private final long deployStepWaitTimeMs;
    private final boolean stepComplete;
    private final boolean autoAdvanceDeploySteps;
    private final Set<SingularityTaskId> failedDeployTasks;
    private final long timestamp;

    @JsonCreator
    public SingularityDeployProgress(@JsonProperty(value="targetActiveInstances") int targetActiveInstances, @JsonProperty(value="deployInstanceCountPerStep") int deployInstanceCountPerStep, @JsonProperty(value="deployStepWaitTimeMs") long deployStepWaitTimeMs, @JsonProperty(value="stepComplete") boolean stepComplete, @JsonProperty(value="autoAdvanceDeploySteps") boolean autoAdvanceDeploySteps, @JsonProperty(value="failedDeployTasks") Set<SingularityTaskId> failedDeployTasks, @JsonProperty(value="timestamp") long timestamp) {
        this.targetActiveInstances = targetActiveInstances;
        this.deployInstanceCountPerStep = deployInstanceCountPerStep;
        this.deployStepWaitTimeMs = deployStepWaitTimeMs;
        this.stepComplete = stepComplete;
        this.autoAdvanceDeploySteps = autoAdvanceDeploySteps;
        this.failedDeployTasks = failedDeployTasks;
        this.timestamp = timestamp;
    }

    public int getTargetActiveInstances() {
        return this.targetActiveInstances;
    }

    public int getDeployInstanceCountPerStep() {
        return this.deployInstanceCountPerStep;
    }

    public boolean isStepComplete() {
        return this.stepComplete;
    }

    public boolean isAutoAdvanceDeploySteps() {
        return this.autoAdvanceDeploySteps;
    }

    public long getDeployStepWaitTimeMs() {
        return this.deployStepWaitTimeMs;
    }

    public Set<SingularityTaskId> getFailedDeployTasks() {
        return this.failedDeployTasks;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public SingularityDeployProgress withNewInstances(int instances) {
        return new SingularityDeployProgress(instances, this.deployInstanceCountPerStep, this.deployStepWaitTimeMs, false, this.autoAdvanceDeploySteps, this.failedDeployTasks, System.currentTimeMillis());
    }

    public SingularityDeployProgress withCompletedStep() {
        return new SingularityDeployProgress(this.targetActiveInstances, this.deployInstanceCountPerStep, this.deployStepWaitTimeMs, true, this.autoAdvanceDeploySteps, this.failedDeployTasks, System.currentTimeMillis());
    }

    public SingularityDeployProgress withFailedTasks(Set<SingularityTaskId> failedTasks) {
        return new SingularityDeployProgress(this.targetActiveInstances, this.deployInstanceCountPerStep, this.deployStepWaitTimeMs, false, this.autoAdvanceDeploySteps, failedTasks, System.currentTimeMillis());
    }

    public String toString() {
        return "SingularityIncrementalDeployProgress{targetActiveInstances=" + this.targetActiveInstances + ", deployInstanceCountPerStep=" + this.deployInstanceCountPerStep + ", deployStepWaitTimeMs=" + this.deployStepWaitTimeMs + ", stepComplete=" + this.stepComplete + ", autoAdvanceDeploySteps=" + this.autoAdvanceDeploySteps + ", failedDeployTasks=" + this.failedDeployTasks + ", timestamp=" + this.timestamp + '}';
    }
}

