/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.deploy;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.deploy.S3Artifact;
import java.util.Objects;

public class S3ArtifactSignature
extends S3Artifact {
    private final String artifactFilename;

    @JsonCreator
    public S3ArtifactSignature(@JsonProperty(value="name") String name, @JsonProperty(value="filename") String filename, @JsonProperty(value="md5sum") Optional<String> md5sum, @JsonProperty(value="filesize") Optional<Long> filesize, @JsonProperty(value="s3Bucket") String s3Bucket, @JsonProperty(value="s3ObjectKey") String s3ObjectKey, @JsonProperty(value="artifactFilename") String artifactFilename, @JsonProperty(value="targetFolderRelativeToTask") Optional<String> targetFolderRelativeToTask) {
        super(name, filename, md5sum, filesize, s3Bucket, s3ObjectKey, targetFolderRelativeToTask);
        this.artifactFilename = artifactFilename;
    }

    public String getArtifactFilename() {
        return this.artifactFilename;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        S3ArtifactSignature that = (S3ArtifactSignature)o;
        return Objects.equals(this.artifactFilename, that.artifactFilename);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.artifactFilename);
    }

    @Override
    public String toString() {
        return "S3ArtifactSignature [artifactFilename=" + this.artifactFilename + ", parent=" + super.toString() + "]";
    }
}

