/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.baragon.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.io.BaseEncoding;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

@JsonIgnoreProperties(ignoreUnknown=true)
public class UpstreamInfo {
    private final String upstream;
    @Size(max=250)
    @Pattern(regexp="^$|[^\\s/|]+", message="cannot contain whitespace, '/', or '|'")
    private final String requestId;
    @Size(max=100)
    @Pattern(regexp="^$|[^\\s|]+", message="cannot contain whitespace, '/', or '|'")
    private final String rackId;
    private final Optional<String> originalPath;

    @JsonCreator
    public static UpstreamInfo fromString(String value) {
        String[] split = value.split("\\|", -1);
        if (split[0].contains(".") && split.length == 1) {
            return UpstreamInfo.fromUnEncodedString(value);
        }
        String upstream = new String(BaseEncoding.base64Url().decode(split[0]), Charsets.UTF_8);
        Optional<String> requestId = split.length > 1 && !split[1].equals("") ? Optional.of(split[1]) : Optional.absent();
        Optional<String> rackId = split.length > 2 && !split[2].equals("") ? Optional.of(split[2]) : Optional.absent();
        return new UpstreamInfo(upstream, requestId, rackId, Optional.of(value));
    }

    public static UpstreamInfo fromUnEncodedString(String upstream) {
        return new UpstreamInfo(upstream, Optional.absent(), Optional.absent(), Optional.of(upstream));
    }

    public UpstreamInfo(String upstream, Optional<String> requestId, Optional<String> rackId) {
        this(upstream, requestId, rackId, Optional.absent());
    }

    @JsonCreator
    public UpstreamInfo(@JsonProperty(value="upstream") String upstream, @JsonProperty(value="requestId") Optional<String> requestId, @JsonProperty(value="rackId") Optional<String> rackId, @JsonProperty(value="originalPath") Optional<String> originalPath) {
        this.upstream = upstream;
        this.requestId = requestId.or("");
        this.rackId = rackId.or("");
        this.originalPath = originalPath;
    }

    public String getUpstream() {
        return this.upstream;
    }

    public Optional<String> getRequestId() {
        return Strings.isNullOrEmpty(this.requestId) ? Optional.absent() : Optional.of(this.requestId);
    }

    public Optional<String> getRackId() {
        return Strings.isNullOrEmpty(this.rackId) ? Optional.absent() : Optional.of(this.rackId);
    }

    @JsonIgnore
    public Optional<String> getOriginalPath() {
        return this.originalPath;
    }

    public String toString() {
        return this.upstream;
    }

    public String toPath() {
        return String.format("%s|%s|%s", this.sanitizeUpstream(this.upstream), this.requestId, this.rackId);
    }

    protected String sanitizeUpstream(String name) {
        return BaseEncoding.base64Url().encode(name.getBytes(Charsets.UTF_8));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpstreamInfo that = (UpstreamInfo)o;
        if (!this.rackId.equals(that.rackId)) {
            return false;
        }
        if (!this.requestId.equals(that.requestId)) {
            return false;
        }
        if (!this.upstream.equals(that.upstream)) {
            return false;
        }
        return this.originalPath.equals(that.originalPath);
    }

    public int hashCode() {
        int result = this.upstream.hashCode();
        result = 31 * result + this.requestId.hashCode();
        result = 31 * result + this.rackId.hashCode();
        result = 31 * result + this.originalPath.hashCode();
        return result;
    }
}

