/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.baragon.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.hubspot.baragon.models.BaragonAgentEc2Metadata;
import com.hubspot.baragon.models.BaragonAgentMetadata;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BaragonKnownAgentMetadata
extends BaragonAgentMetadata {
    private long lastSeenAt;

    public static BaragonKnownAgentMetadata fromAgentMetadata(BaragonAgentMetadata agentMetadata, long lastSeenAt) {
        return new BaragonKnownAgentMetadata(agentMetadata.getBaseAgentUri(), agentMetadata.getAgentId(), agentMetadata.getDomain(), agentMetadata.getEc2(), agentMetadata.getExtraAgentData(), lastSeenAt);
    }

    @JsonCreator
    public BaragonKnownAgentMetadata(@JsonProperty(value="baseAgentUri") String baseAgentUri, @JsonProperty(value="agentId") String agentId, @JsonProperty(value="domain") Optional<String> domain, @JsonProperty(value="ec2") BaragonAgentEc2Metadata ec2, @JsonProperty(value="extraAgentData") Map<String, String> extraAgentData, @JsonProperty(value="lastSeenAt") long lastSeenAt) {
        super(baseAgentUri, agentId, domain, ec2, extraAgentData);
        this.lastSeenAt = lastSeenAt;
    }

    public long getLastSeenAt() {
        return this.lastSeenAt;
    }

    public void setLastSeenAt(long lastSeenAt) {
        this.lastSeenAt = lastSeenAt;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BaragonKnownAgentMetadata that = (BaragonKnownAgentMetadata)o;
        return this.lastSeenAt == that.lastSeenAt;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.lastSeenAt ^ this.lastSeenAt >>> 32);
        return result;
    }

    @Override
    public String toString() {
        return Objects.toStringHelper(this).add("baseAgentUri", this.getBaseAgentUri()).add("domain", this.getDomain()).add("agentId", this.getAgentId()).add("lastSeenAt", this.lastSeenAt).toString();
    }
}

