/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars;

import com.github.jknack.handlebars.ValueResolver;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Validate;

public class Context {
    private static final String PATH_SEPARATOR = "./";
    private static final String PARENT_ATTR = "../";
    private static final String PARENT = "..";
    private static final String THIS = "this";
    private static final String MUSTACHE_THIS = ".";
    private static final Object NULL = new Object();
    private static final Pattern IDX = Pattern.compile("\\[((.)+)\\]");
    private static final Pattern INT = Pattern.compile("\\d+");
    public static final String PARTIALS = Context.class.getName() + "#partials";
    public static final String INVOCATION_STACK = Context.class.getName() + "#invocationStack";
    public static final String PARAM_SIZE = Context.class.getName() + "#paramSize";
    private Context parent;
    private Object model;
    private Map<String, Object> data;
    private Context extendedContext;
    private ValueResolver resolver;

    protected Context(Object model) {
        if (model instanceof Context) {
            throw new IllegalArgumentException("Invalid model type:" + model.getClass().getName());
        }
        this.model = model;
    }

    private static Context root(Object model) {
        Context root = new Context(model);
        root.extendedContext = new Context(new HashMap());
        root.parent = null;
        root.data = new HashMap<String, Object>();
        root.data.put(PARTIALS, new HashMap());
        root.data.put(INVOCATION_STACK, new LinkedList());
        return root;
    }

    private static Context child(Context parent, Object model) {
        Validate.notNull(parent, "A parent context is required.", new Object[0]);
        Context child = new Context(model);
        child.extendedContext = new Context(new HashMap());
        child.parent = parent;
        child.data = parent.data;
        return child;
    }

    private void combine(String name, Object model) {
        Validate.notEmpty(name, "The variable's name is required.", new Object[0]);
        Map map = (Map)this.extendedContext.model;
        map.put(name, model);
    }

    private void combine(Map<String, ?> model) {
        Map map = (Map)this.extendedContext.model;
        map.putAll(model);
    }

    public <T> T data(String name) {
        return (T)this.data.get(name);
    }

    public Context data(String name, Object value) {
        Validate.notEmpty(name, "The attribute's name is required.", new Object[0]);
        this.data.put(name, value);
        return this;
    }

    public Context data(Map<String, ?> attributes) {
        Validate.notNull(attributes, "The attributes are required.", new Object[0]);
        this.data.putAll(attributes);
        return this;
    }

    public Object model() {
        return this.model;
    }

    public Context parent() {
        return this.parent;
    }

    public Set<Map.Entry<String, Object>> propertySet(Object context) {
        if (context == null) {
            return Collections.emptySet();
        }
        if (context instanceof Context) {
            return this.resolver.propertySet(((Context)context).model);
        }
        return this.resolver.propertySet(context);
    }

    public Set<Map.Entry<String, Object>> propertySet() {
        return this.propertySet(this.model);
    }

    public Object get(String key) {
        if (MUSTACHE_THIS.equals(key) || THIS.equals(key)) {
            return this.internalGet(this.model);
        }
        if (key.equals(PARENT)) {
            return this.parent == null ? null : this.internalGet(this.parent.model);
        }
        if (key.startsWith(PARENT_ATTR)) {
            return this.parent == null ? null : this.parent.get(key.substring(PARENT_ATTR.length()));
        }
        String[] path = this.toPath(key);
        Object value = this.internalGet(path);
        if (value == null) {
            String dataKey;
            value = this.get(this.extendedContext, key);
            if (value == null && this.data != null && (value = this.data.get(dataKey = key.charAt(0) == '@' ? key.substring(1) : key)) == null && path.length > 1) {
                Context dataContext = Context.newBuilder(this.data).resolver(this.resolver).build();
                dataContext.data = null;
                value = dataContext.get(dataKey);
                dataContext.destroy();
            }
            if (value == null && !path[0].equals(THIS)) {
                value = this.get(this.parent, key);
            }
        }
        return value == NULL ? null : value;
    }

    private Object get(Context external, String key) {
        return external == null ? null : external.get(key);
    }

    private String[] toPath(String key) {
        StringTokenizer tokenizer = new StringTokenizer(key, PATH_SEPARATOR);
        int len = tokenizer.countTokens();
        if (len == 1) {
            return new String[]{key};
        }
        String[] path = new String[len];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            path[i++] = tokenizer.nextToken();
        }
        return path;
    }

    private Object internalGet(Object candidate) {
        Object resolved = this.resolver.resolve(candidate);
        return resolved == null ? candidate : resolved;
    }

    private Object internalGet(String ... path) {
        int start;
        Object current = this.model;
        for (int i = start = path[0].equals(THIS) ? 1 : 0; i < path.length - 1; ++i) {
            if ((current = this.resolve(current, path[i])) != null) continue;
            return null;
        }
        String name = path[path.length - 1];
        Object value = this.resolve(current, name);
        if (value == null && current != this.model) {
            value = NULL;
        }
        return value;
    }

    private Object resolve(Object current, String expression) {
        if (current == null) {
            return null;
        }
        Matcher matcher = IDX.matcher(expression);
        if (matcher.matches()) {
            String idx = matcher.group(1);
            if (INT.matcher(idx).matches()) {
                int pos = Integer.parseInt(idx);
                try {
                    if (current instanceof List) {
                        return ((List)current).get(pos);
                    }
                    if (current.getClass().isArray()) {
                        return Array.get(current, pos);
                    }
                }
                catch (IndexOutOfBoundsException exception) {
                    return null;
                }
            }
            return this.resolver.resolve(current, idx);
        }
        return this.resolver.resolve(current, expression);
    }

    private void setResolver(ValueResolver resolver) {
        this.resolver = resolver;
        this.extendedContext.resolver = resolver;
    }

    public void destroy() {
        this.model = null;
        if (this.parent == null && this.data != null) {
            this.data.clear();
        }
        if (this.extendedContext != null) {
            this.extendedContext.destroy();
        }
        this.parent = null;
        this.resolver = null;
        this.data = null;
    }

    public String toString() {
        return String.valueOf(this.model);
    }

    public static Builder newBuilder(Context parent, Object model) {
        Validate.notNull(parent, "The parent context is required.", new Object[0]);
        return new Builder(parent, model);
    }

    public static Builder newBuilder(Object model) {
        return new Builder(model);
    }

    public static Context newContext(Context parent, Object model) {
        return Context.newBuilder(parent, model).build();
    }

    public static Context newContext(Object model) {
        return Context.newBuilder(model).build();
    }

    public static final class Builder {
        private Context context;

        private Builder(Context parent, Object model) {
            this.context = Context.child(parent, model);
        }

        private Builder(Object model) {
            this.context = Context.root(model);
        }

        public Builder combine(String name, Object model) {
            this.context.combine(name, model);
            return this;
        }

        public Builder combine(Map<String, ?> model) {
            this.context.combine(model);
            return this;
        }

        public Builder resolver(ValueResolver ... resolvers) {
            Validate.notEmpty(resolvers, "At least one value-resolver must be present.", new Object[0]);
            this.context.setResolver(new CompositeValueResolver(resolvers));
            return this;
        }

        public Context build() {
            if (this.context.resolver == null) {
                if (this.context.parent != null) {
                    this.context.resolver = this.context.parent.resolver;
                } else {
                    this.context.setResolver(new CompositeValueResolver(ValueResolver.VALUE_RESOLVERS));
                }
                if (this.context.extendedContext != null) {
                    this.context.extendedContext.resolver = this.context.resolver;
                }
            }
            return this.context;
        }
    }

    private static class CompositeValueResolver
    implements ValueResolver {
        private ValueResolver[] resolvers;

        public CompositeValueResolver(ValueResolver ... resolvers) {
            this.resolvers = resolvers;
        }

        @Override
        public Object resolve(Object context, String name) {
            for (ValueResolver resolver : this.resolvers) {
                Object value = resolver.resolve(context, name);
                if (value == UNRESOLVED) continue;
                return value == null ? NULL : value;
            }
            return null;
        }

        @Override
        public Object resolve(Object context) {
            for (ValueResolver resolver : this.resolvers) {
                Object value = resolver.resolve(context);
                if (value == UNRESOLVED) continue;
                return value == null ? NULL : value;
            }
            return null;
        }

        @Override
        public Set<Map.Entry<String, Object>> propertySet(Object context) {
            LinkedHashSet<Map.Entry<String, Object>> propertySet = new LinkedHashSet<Map.Entry<String, Object>>();
            for (ValueResolver resolver : this.resolvers) {
                propertySet.addAll(resolver.propertySet(context));
            }
            return propertySet;
        }
    }
}

