/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor.task;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.hubspot.deploy.ExecutorData;
import com.hubspot.singularity.executor.TemplateManager;
import com.hubspot.singularity.executor.config.SingularityExecutorConfiguration;
import com.hubspot.singularity.executor.models.DockerContext;
import com.hubspot.singularity.executor.models.EnvironmentContext;
import com.hubspot.singularity.executor.models.RunnerContext;
import com.hubspot.singularity.executor.task.SingularityExecutorArtifactFetcher;
import com.hubspot.singularity.executor.task.SingularityExecutorTask;
import com.hubspot.singularity.executor.utils.DockerUtils;
import com.hubspot.singularity.executor.utils.ExecutorUtils;
import com.hubspot.singularity.runner.base.shared.ProcessFailedException;
import com.spotify.docker.client.DockerException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.apache.mesos.Protos;

public class SingularityExecutorTaskProcessBuilder
implements Callable<ProcessBuilder> {
    private final SingularityExecutorTask task;
    private final TemplateManager templateManager;
    private final SingularityExecutorConfiguration configuration;
    private final String executorPid;
    private final ExecutorUtils executorUtils;
    private final ExecutorData executorData;
    private final SingularityExecutorArtifactFetcher artifactFetcher;
    private Optional<SingularityExecutorArtifactFetcher.SingularityExecutorTaskArtifactFetcher> taskArtifactFetcher;
    private DockerUtils dockerUtils;

    public SingularityExecutorTaskProcessBuilder(SingularityExecutorTask task, ExecutorUtils executorUtils, SingularityExecutorArtifactFetcher artifactFetcher, TemplateManager templateManager, SingularityExecutorConfiguration configuration, ExecutorData executorData, String executorPid, DockerUtils dockerUtils) {
        this.executorData = executorData;
        this.task = task;
        this.executorUtils = executorUtils;
        this.artifactFetcher = artifactFetcher;
        this.templateManager = templateManager;
        this.configuration = configuration;
        this.executorPid = executorPid;
        this.taskArtifactFetcher = Optional.absent();
        this.dockerUtils = dockerUtils;
    }

    @Override
    public ProcessBuilder call() throws Exception {
        if (this.task.getTaskInfo().hasContainer() && this.task.getTaskInfo().getContainer().hasDocker()) {
            this.executorUtils.sendStatusUpdate(this.task.getDriver(), this.task.getTaskInfo(), Protos.TaskState.TASK_STARTING, String.format("Pulling image... (executor pid: %s)", this.executorPid), this.task.getLog());
            try {
                this.dockerUtils.pull(this.task.getTaskInfo().getContainer().getDocker().getImage());
            }
            catch (DockerException e) {
                throw new ProcessFailedException("Could not pull docker image", (Throwable)e);
            }
        }
        this.executorUtils.sendStatusUpdate(this.task.getDriver(), this.task.getTaskInfo(), Protos.TaskState.TASK_STARTING, String.format("Staging files... (executor pid: %s)", this.executorPid), this.task.getLog());
        this.taskArtifactFetcher = Optional.of((Object)this.artifactFetcher.buildTaskFetcher(this.executorData, this.task));
        ((SingularityExecutorArtifactFetcher.SingularityExecutorTaskArtifactFetcher)this.taskArtifactFetcher.get()).fetchFiles();
        this.task.getArtifactVerifier().checkSignatures();
        ProcessBuilder processBuilder = this.buildProcessBuilder(this.task.getTaskInfo(), this.executorData);
        this.task.getTaskLogManager().setup();
        return processBuilder;
    }

    public void cancel() {
        if (this.taskArtifactFetcher.isPresent()) {
            ((SingularityExecutorArtifactFetcher.SingularityExecutorTaskArtifactFetcher)this.taskArtifactFetcher.get()).cancel();
        }
    }

    private Path getPath(String filename) {
        return this.task.getTaskDefinition().getTaskDirectoryPath().resolve(filename);
    }

    private String getCommand(ExecutorData executorData) {
        StringBuilder bldr = new StringBuilder(executorData.getCmd());
        for (String extraCmdLineArg : executorData.getExtraCmdLineArgs()) {
            bldr.append(" ");
            bldr.append(extraCmdLineArg);
        }
        return bldr.toString();
    }

    private String getExecutorUser() {
        return System.getProperty("user.name");
    }

    private ProcessBuilder buildProcessBuilder(Protos.TaskInfo taskInfo, ExecutorData executorData) {
        String cmd = this.getCommand(executorData);
        RunnerContext runnerContext = new RunnerContext(cmd, this.configuration.getTaskAppDirectory(), this.configuration.getLogrotateToDirectory(), (String)executorData.getUser().or((Object)this.configuration.getDefaultRunAsUser()), this.configuration.getServiceLog(), this.task.getTaskId(), (Optional<Integer>)executorData.getMaxTaskThreads().or(this.configuration.getMaxTaskThreads()), !this.getExecutorUser().equals(executorData.getUser().or((Object)this.configuration.getDefaultRunAsUser())), (Integer)executorData.getMaxOpenFiles().orNull(), String.format(this.configuration.getSwitchUserCommandFormat(), executorData.getUser().or((Object)this.configuration.getDefaultRunAsUser())));
        EnvironmentContext environmentContext = new EnvironmentContext(taskInfo);
        if (taskInfo.hasContainer() && taskInfo.getContainer().hasDocker()) {
            this.task.getLog().info("Writing a runner script to execute {} in docker container", (Object)cmd);
            this.templateManager.writeDockerScript(this.getPath("runner.sh"), new DockerContext(environmentContext, runnerContext, this.configuration.getDockerPrefix(), this.configuration.getDockerStopTimeout(), taskInfo.getContainer().getDocker().getPrivileged()));
        } else {
            this.templateManager.writeEnvironmentScript(this.getPath("deploy.env"), environmentContext);
            this.task.getLog().info("Writing a runner script to execute {} with {}", (Object)cmd, (Object)runnerContext);
            this.templateManager.writeRunnerScript(this.getPath("runner.sh"), runnerContext);
        }
        ArrayList command = Lists.newArrayList();
        command.add("bash");
        command.add("runner.sh");
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        processBuilder.directory(this.task.getTaskDefinition().getTaskDirectoryPath().toFile());
        processBuilder.redirectError(this.task.getTaskDefinition().getExecutorBashOutPath().toFile());
        processBuilder.redirectOutput(this.task.getTaskDefinition().getExecutorBashOutPath().toFile());
        return processBuilder;
    }

    public String toString() {
        return "SingularityExecutorTaskProcessBuilder [task=" + this.task.getTaskId() + "]";
    }
}

