/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor.task;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.hubspot.singularity.SingularityS3FormatHelper;
import com.hubspot.singularity.SingularityTaskId;
import com.hubspot.singularity.executor.TemplateManager;
import com.hubspot.singularity.executor.config.SingularityExecutorConfiguration;
import com.hubspot.singularity.executor.models.LogrotateTemplateContext;
import com.hubspot.singularity.executor.task.SingularityExecutorTaskDefinition;
import com.hubspot.singularity.runner.base.configuration.SingularityRunnerBaseConfiguration;
import com.hubspot.singularity.runner.base.shared.JsonObjectFileHelper;
import com.hubspot.singularity.runner.base.shared.S3UploadMetadata;
import com.hubspot.singularity.runner.base.shared.SimpleProcessManager;
import com.hubspot.singularity.runner.base.shared.TailMetadata;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class SingularityExecutorTaskLogManager {
    private final SingularityExecutorTaskDefinition taskDefinition;
    private final TemplateManager templateManager;
    private final SingularityRunnerBaseConfiguration baseConfiguration;
    private final SingularityExecutorConfiguration configuration;
    private final Logger log;
    private final JsonObjectFileHelper jsonObjectFileHelper;

    public SingularityExecutorTaskLogManager(SingularityExecutorTaskDefinition taskDefinition, TemplateManager templateManager, SingularityRunnerBaseConfiguration baseConfiguration, SingularityExecutorConfiguration configuration, Logger log, JsonObjectFileHelper jsonObjectFileHelper) {
        this.log = log;
        this.taskDefinition = taskDefinition;
        this.templateManager = templateManager;
        this.configuration = configuration;
        this.baseConfiguration = baseConfiguration;
        this.jsonObjectFileHelper = jsonObjectFileHelper;
    }

    public void setup() {
        this.ensureServiceOutExists();
        this.writeLogrotateFile();
        this.writeTailMetadata(false);
        this.writeS3MetadataFile(false);
    }

    private void writeLogrotateFile() {
        this.log.info("Writing logrotate configuration file to {}", (Object)this.getLogrotateConfPath());
        this.templateManager.writeLogrotateFile(this.getLogrotateConfPath(), new LogrotateTemplateContext(this.configuration, this.taskDefinition));
    }

    public boolean teardown() {
        boolean writeTailMetadataSuccess = this.writeTailMetadata(true);
        this.ensureServiceOutExists();
        this.copyLogTail();
        if (this.manualLogrotate()) {
            boolean removeLogRotateFileSuccess = this.removeLogrotateFile();
            boolean writeS3MetadataFileSuccess = this.writeS3MetadataFile(true);
            return writeTailMetadataSuccess && removeLogRotateFileSuccess && writeS3MetadataFileSuccess;
        }
        return false;
    }

    private void copyLogTail() {
        if (this.configuration.getTailLogLinesToSave() <= 0) {
            return;
        }
        Path tailOfLogPath = this.taskDefinition.getTaskDirectoryPath().resolve(this.configuration.getServiceFinishedTailLog());
        if (Files.exists(tailOfLogPath, new LinkOption[0])) {
            this.log.debug("{} already existed, skipping tail", (Object)tailOfLogPath);
            return;
        }
        ImmutableList cmd = ImmutableList.of((Object)"tail", (Object)"-n", (Object)Integer.toString(this.configuration.getTailLogLinesToSave()), (Object)this.taskDefinition.getServiceLogOut());
        try {
            new SimpleProcessManager(this.log).runCommand((List)cmd, ProcessBuilder.Redirect.to(tailOfLogPath.toFile()));
        }
        catch (Throwable t) {
            this.log.error("Failed saving tail of log {} to {}", new Object[]{this.taskDefinition.getServiceLogOut(), this.configuration.getServiceFinishedTailLog(), t});
        }
    }

    public boolean removeLogrotateFile() {
        boolean deleted = false;
        try {
            deleted = Files.deleteIfExists(this.getLogrotateConfPath());
        }
        catch (Throwable t) {
            this.log.trace("Couldn't delete {}", (Object)this.getLogrotateConfPath(), (Object)t);
            return false;
        }
        this.log.trace("Deleted {} : {}", (Object)this.getLogrotateConfPath(), (Object)deleted);
        return true;
    }

    public boolean manualLogrotate() {
        if (!Files.exists(this.getLogrotateConfPath(), new LinkOption[0])) {
            this.log.info("{} did not exist, skipping manual logrotation", (Object)this.getLogrotateConfPath());
            return true;
        }
        ImmutableList command = ImmutableList.of((Object)this.configuration.getLogrotateCommand(), (Object)"-f", (Object)"-s", (Object)this.taskDefinition.getLogrotateStateFilePath().toString(), (Object)this.getLogrotateConfPath().toString());
        try {
            new SimpleProcessManager(this.log).runCommand((List)command);
            return true;
        }
        catch (Throwable t) {
            this.log.warn("Tried to manually logrotate using {}, but caught", (Object)this.getLogrotateConfPath(), (Object)t);
            return false;
        }
    }

    private void ensureServiceOutExists() {
        try {
            if (!Files.exists(this.taskDefinition.getServiceLogOutPath(), new LinkOption[0])) {
                Files.createFile(this.taskDefinition.getServiceLogOutPath(), new FileAttribute[0]);
            }
        }
        catch (FileAlreadyExistsException faee) {
            this.log.debug("Executor out {} already existed", (Object)this.taskDefinition.getServiceLogOut());
        }
        catch (Throwable t) {
            this.log.error("Failed creating executor out {}", (Object)this.taskDefinition.getServiceLogOut(), (Object)t);
        }
    }

    private boolean writeTailMetadata(boolean finished) {
        if (!this.taskDefinition.getExecutorData().getLoggingTag().isPresent()) {
            if (!finished) {
                this.log.warn("Not writing logging metadata because logging tag is absent");
            }
            return true;
        }
        TailMetadata tailMetadata = new TailMetadata(this.taskDefinition.getServiceLogOut(), (String)this.taskDefinition.getExecutorData().getLoggingTag().get(), this.taskDefinition.getExecutorData().getLoggingExtraFields(), finished);
        Path path = TailMetadata.getTailMetadataPath((Path)Paths.get(this.baseConfiguration.getLogWatcherMetadataDirectory(), new String[0]), (String)this.baseConfiguration.getLogWatcherMetadataSuffix(), (TailMetadata)tailMetadata);
        return this.jsonObjectFileHelper.writeObject((Object)tailMetadata, path, this.log);
    }

    private String getS3Glob() {
        ArrayList<String> fileNames = new ArrayList<String>(this.configuration.getS3UploaderAdditionalFiles());
        fileNames.add(this.taskDefinition.getServiceLogOutPath().getFileName().toString());
        return String.format("{%s}*.gz*", Joiner.on((String)",").join(fileNames));
    }

    private String getS3KeyPattern() {
        String s3KeyPattern = this.configuration.getS3UploaderKeyPattern();
        SingularityTaskId singularityTaskId = this.getSingularityTaskId();
        return SingularityS3FormatHelper.getS3KeyFormat((String)s3KeyPattern, (SingularityTaskId)singularityTaskId, (Optional)this.taskDefinition.getExecutorData().getLoggingTag());
    }

    private SingularityTaskId getSingularityTaskId() {
        return SingularityTaskId.valueOf((String)this.taskDefinition.getTaskId());
    }

    public Path getLogrotateConfPath() {
        return Paths.get(this.configuration.getLogrotateConfDirectory(), new String[0]).resolve(this.taskDefinition.getTaskId());
    }

    private boolean writeS3MetadataFile(boolean finished) {
        Path logrotateDirectory = this.taskDefinition.getServiceLogOutPath().getParent().resolve(this.configuration.getLogrotateToDirectory());
        S3UploadMetadata s3UploadMetadata = new S3UploadMetadata(logrotateDirectory.toString(), this.getS3Glob(), this.configuration.getS3UploaderBucket(), this.getS3KeyPattern(), finished, Optional.absent(), Optional.absent(), Optional.absent(), Optional.absent(), Optional.absent());
        String s3UploadMetadataFileName = String.format("%s%s", this.taskDefinition.getTaskId(), this.baseConfiguration.getS3UploaderMetadataSuffix());
        Path s3UploadMetadataPath = Paths.get(this.baseConfiguration.getS3UploaderMetadataDirectory(), new String[0]).resolve(s3UploadMetadataFileName);
        return this.jsonObjectFileHelper.writeObject((Object)s3UploadMetadata, s3UploadMetadataPath, this.log);
    }
}

