/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.deploy.ExecutorData;
import java.nio.file.Path;
import java.nio.file.Paths;

public class SingularityExecutorTaskDefinition {
    private final ExecutorData executorData;
    private final String taskId;
    private final Path taskDirectoryPath;
    private final String executorBashOut;
    private final String serviceLogOut;
    private final String taskAppDirectory;
    private final String logrotateStateFile;
    private final String executorPid;

    @JsonCreator
    public SingularityExecutorTaskDefinition(@JsonProperty(value="taskId") String taskId, @JsonProperty(value="executorData") ExecutorData executorData, @JsonProperty(value="taskDirectory") String taskDirectory, @JsonProperty(value="executorPid") String executorPid, @JsonProperty(value="serviceLogOut") String serviceLogOut, @JsonProperty(value="taskAppDirectory") String taskAppDirectory, @JsonProperty(value="executorBashOut") String executorBashOut, @JsonProperty(value="logrotateStateFilePath") String logrotateStateFile) {
        this.executorData = executorData;
        this.taskId = taskId;
        this.taskDirectoryPath = Paths.get(taskDirectory, new String[0]);
        this.executorPid = executorPid;
        this.executorBashOut = executorBashOut;
        this.serviceLogOut = serviceLogOut;
        this.taskAppDirectory = taskAppDirectory;
        this.logrotateStateFile = logrotateStateFile;
    }

    @JsonIgnore
    public Path getTaskDirectoryPath() {
        return this.taskDirectoryPath;
    }

    @JsonIgnore
    public Path getExecutorBashOutPath() {
        return this.taskDirectoryPath.resolve(this.executorBashOut);
    }

    @JsonIgnore
    public Path getServiceLogOutPath() {
        return this.taskDirectoryPath.resolve(this.serviceLogOut);
    }

    @JsonIgnore
    public Path getTaskAppDirectoryPath() {
        return this.taskDirectoryPath.resolve(this.taskAppDirectory);
    }

    @JsonIgnore
    public Path getLogrotateStateFilePath() {
        return this.taskDirectoryPath.resolve(this.logrotateStateFile);
    }

    public String getTaskDirectory() {
        return this.taskDirectoryPath.toString();
    }

    public String getExecutorBashOut() {
        return this.getExecutorBashOutPath().toString();
    }

    public String getServiceLogOut() {
        return this.getServiceLogOutPath().toString();
    }

    public String getTaskAppDirectory() {
        return this.getTaskAppDirectoryPath().toString();
    }

    public String getLogrotateStateFile() {
        return this.getLogrotateStateFilePath().toString();
    }

    public ExecutorData getExecutorData() {
        return this.executorData;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getExecutorPid() {
        return this.executorPid;
    }

    @JsonIgnore
    public Optional<Integer> getExecutorPidSafe() {
        try {
            return Optional.of((Object)Integer.parseInt(this.executorPid));
        }
        catch (NumberFormatException nfe) {
            return Optional.absent();
        }
    }

    public String toString() {
        return "SingularityExecutorTaskDefinition [executorData=" + this.executorData + ", taskId=" + this.taskId + ", taskDirectoryPath=" + this.taskDirectoryPath + ", executorBashOut=" + this.executorBashOut + ", serviceLogOut=" + this.serviceLogOut + ", taskAppDirectory=" + this.taskAppDirectory + ", logrotateStateFile=" + this.logrotateStateFile + ", executorPid=" + this.executorPid + "]";
    }
}

