/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor.task;

import com.google.common.collect.ImmutableList;
import com.hubspot.singularity.executor.config.SingularityExecutorConfiguration;
import com.hubspot.singularity.executor.task.SingularityExecutorTaskDefinition;
import com.hubspot.singularity.executor.task.SingularityExecutorTaskLogManager;
import com.hubspot.singularity.runner.base.shared.SimpleProcessManager;
import com.spotify.docker.client.ContainerNotFoundException;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.messages.ContainerInfo;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.slf4j.Logger;

public class SingularityExecutorTaskCleanup {
    private final SingularityExecutorTaskDefinition taskDefinition;
    private final SingularityExecutorTaskLogManager taskLogManager;
    private final SingularityExecutorConfiguration configuration;
    private final Logger log;
    private final DockerClient dockerClient;

    public SingularityExecutorTaskCleanup(SingularityExecutorTaskLogManager taskLogManager, SingularityExecutorConfiguration configuration, SingularityExecutorTaskDefinition taskDefinition, Logger log, DockerClient dockerClient) {
        this.configuration = configuration;
        this.taskLogManager = taskLogManager;
        this.taskDefinition = taskDefinition;
        this.log = log;
        this.dockerClient = dockerClient;
    }

    public boolean cleanup(boolean cleanupTaskAppDirectory, boolean isDocker) {
        Path taskDirectory = Paths.get(this.taskDefinition.getTaskDirectory(), new String[0]);
        boolean dockerCleanSuccess = true;
        if (isDocker) {
            dockerCleanSuccess = this.cleanDocker();
        }
        if (!Files.exists(taskDirectory, new LinkOption[0])) {
            this.log.info("Directory {} didn't exist for cleanup", (Object)taskDirectory);
            this.taskLogManager.removeLogrotateFile();
            return this.cleanTaskDefinitionFile() && dockerCleanSuccess;
        }
        boolean logTearDownSuccess = this.taskLogManager.teardown();
        boolean cleanupTaskAppDirectorySuccess = false;
        if (cleanupTaskAppDirectory) {
            cleanupTaskAppDirectorySuccess = this.cleanupTaskAppDirectory();
        }
        this.log.info("Cleaned up logs ({}) and task app directory ({})", (Object)logTearDownSuccess, (Object)cleanupTaskAppDirectorySuccess);
        if (logTearDownSuccess && cleanupTaskAppDirectorySuccess) {
            return this.cleanTaskDefinitionFile() && dockerCleanSuccess;
        }
        return false;
    }

    public boolean cleanTaskDefinitionFile() {
        Path taskDefinitionPath = this.configuration.getTaskDefinitionPath(this.taskDefinition.getTaskId());
        this.log.info("Successful cleanup, deleting file {}", (Object)taskDefinitionPath);
        try {
            boolean deleted = Files.deleteIfExists(taskDefinitionPath);
            this.log.info("File deleted ({})", (Object)deleted);
            return true;
        }
        catch (IOException e) {
            this.log.error("Failed deleting {}", (Object)taskDefinitionPath, (Object)e);
            return false;
        }
    }

    private boolean cleanupTaskAppDirectory() {
        String pathToDelete = this.taskDefinition.getTaskAppDirectory();
        this.log.info("Deleting: {}", (Object)pathToDelete);
        try {
            ImmutableList cmd = ImmutableList.of((Object)"rm", (Object)"-rf", (Object)pathToDelete);
            new SimpleProcessManager(this.log).runCommand((List)cmd);
            return true;
        }
        catch (Throwable t) {
            this.log.error("While deleting directory {}", (Object)pathToDelete, (Object)t);
            return false;
        }
    }

    private boolean cleanDocker() {
        String containerName = String.format("%s%s", this.configuration.getDockerPrefix(), this.taskDefinition.getTaskId());
        try {
            ContainerInfo containerInfo = this.dockerClient.inspectContainer(containerName);
            if (containerInfo.state().running().booleanValue()) {
                this.dockerClient.stopContainer(containerName, this.configuration.getDockerStopTimeout());
            }
            this.dockerClient.removeContainer(containerName);
            this.log.info(String.format("Removed container %s", containerName));
            return true;
        }
        catch (ContainerNotFoundException e) {
            this.log.info(String.format("Container %s was already removed", containerName));
            return true;
        }
        catch (Exception e) {
            this.log.info(String.format("Could not ensure removal of docker container due to error %s", e));
            return false;
        }
    }
}

