/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor.task;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.hubspot.deploy.EmbeddedArtifact;
import com.hubspot.deploy.ExecutorData;
import com.hubspot.deploy.RemoteArtifact;
import com.hubspot.deploy.S3Artifact;
import com.hubspot.mesos.JavaUtils;
import com.hubspot.singularity.executor.config.SingularityExecutorConfiguration;
import com.hubspot.singularity.executor.task.SingularityExecutorTask;
import com.hubspot.singularity.s3.base.ArtifactDownloadRequest;
import com.hubspot.singularity.s3.base.ArtifactManager;
import com.hubspot.singularity.s3.base.config.SingularityS3Configuration;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class SingularityExecutorArtifactFetcher {
    private static final String LOCAL_DOWNLOAD_STRING_FORMAT = "http://localhost:%s%s";
    private final AsyncHttpClient localDownloadHttpClient;
    private final String localDownloadUri;
    private final SingularityExecutorConfiguration executorConfiguration;
    private final SingularityS3Configuration s3Configuration;
    private final ObjectMapper objectMapper;

    @Inject
    public SingularityExecutorArtifactFetcher(@Named(value="SingularityExecutorModule.local.download.http.client") AsyncHttpClient localDownloadHttpClient, SingularityS3Configuration s3Configuration, SingularityExecutorConfiguration executorConfiguration, ObjectMapper objectMapper) {
        this.localDownloadHttpClient = localDownloadHttpClient;
        this.executorConfiguration = executorConfiguration;
        this.s3Configuration = s3Configuration;
        this.objectMapper = objectMapper;
        this.localDownloadUri = String.format(LOCAL_DOWNLOAD_STRING_FORMAT, s3Configuration.getLocalDownloadHttpPort(), s3Configuration.getLocalDownloadPath());
    }

    public SingularityExecutorTaskArtifactFetcher buildTaskFetcher(ExecutorData executorData, SingularityExecutorTask task) {
        ArtifactManager artifactManager = new ArtifactManager(this.s3Configuration, task.getLog());
        return new SingularityExecutorTaskArtifactFetcher(artifactManager, executorData, task);
    }

    public class SingularityExecutorTaskArtifactFetcher {
        private final ArtifactManager artifactManager;
        private final ExecutorData executorData;
        private final SingularityExecutorTask task;

        public SingularityExecutorTaskArtifactFetcher(ArtifactManager artifactManager, ExecutorData executorData, SingularityExecutorTask task) {
            this.artifactManager = artifactManager;
            this.executorData = executorData;
            this.task = task;
        }

        public void cancel() {
            this.artifactManager.markKilled();
            this.artifactManager.signalKillToProcessIfActive();
        }

        public void fetchFiles() {
            this.extractFiles(this.task, this.artifactManager, this.executorData);
            boolean fetchS3ArtifactsLocally = true;
            if (SingularityExecutorArtifactFetcher.this.executorConfiguration.isUseLocalDownloadService() && !this.executorData.getS3Artifacts().isEmpty()) {
                long start = System.currentTimeMillis();
                this.task.getLog().info("Fetching {} (S3) artifacts from local download service", (Object)this.executorData.getS3Artifacts().size());
                try {
                    this.downloadFilesFromLocalDownloadService(this.executorData.getS3Artifacts(), this.task);
                    fetchS3ArtifactsLocally = false;
                    this.task.getLog().info("Fetched {} (S3) artifacts from local download service in {}", (Object)this.executorData.getS3Artifacts().size(), (Object)JavaUtils.duration((long)start));
                }
                catch (Throwable t) {
                    this.task.getLog().error("Failed downloading S3 artifacts from local download service - falling back to in-task fetch", t);
                }
            }
            if (fetchS3ArtifactsLocally) {
                for (RemoteArtifact s3Artifact : this.executorData.getS3Artifacts()) {
                    this.downloadRemoteArtifact(s3Artifact, this.artifactManager, this.task);
                }
            }
            for (RemoteArtifact externalArtifact : this.executorData.getExternalArtifacts()) {
                this.downloadRemoteArtifact(externalArtifact, this.artifactManager, this.task);
            }
        }

        private void extractFiles(SingularityExecutorTask task, ArtifactManager artifactManager, ExecutorData executorData) {
            for (EmbeddedArtifact artifact : executorData.getEmbeddedArtifacts()) {
                artifactManager.extract(artifact, task.getTaskDefinition().getTaskDirectoryPath());
            }
        }

        private void downloadFilesFromLocalDownloadService(List<S3Artifact> s3Artifacts, SingularityExecutorTask task) {
            ArrayList futures = Lists.newArrayListWithCapacity((int)s3Artifacts.size());
            for (S3Artifact s3Artifact : s3Artifacts) {
                ArtifactDownloadRequest artifactDownloadRequest = new ArtifactDownloadRequest(task.getTaskDefinition().getTaskDirectory(), s3Artifact);
                task.getLog().debug("Requesting {} from {}", (Object)artifactDownloadRequest, (Object)SingularityExecutorArtifactFetcher.this.localDownloadUri);
                AsyncHttpClient.BoundRequestBuilder postRequestBldr = SingularityExecutorArtifactFetcher.this.localDownloadHttpClient.preparePost(SingularityExecutorArtifactFetcher.this.localDownloadUri);
                try {
                    postRequestBldr.setBody(SingularityExecutorArtifactFetcher.this.objectMapper.writeValueAsBytes((Object)artifactDownloadRequest));
                }
                catch (JsonProcessingException e) {
                    throw Throwables.propagate((Throwable)e);
                }
                try {
                    ListenableFuture future = SingularityExecutorArtifactFetcher.this.localDownloadHttpClient.executeRequest(postRequestBldr.build());
                    futures.add(future);
                }
                catch (IOException ioe) {
                    throw Throwables.propagate((Throwable)ioe);
                }
            }
            for (ListenableFuture future : futures) {
                Response response;
                try {
                    response = (Response)future.get();
                }
                catch (Exception e) {
                    throw Throwables.propagate((Throwable)e);
                }
                task.getLog().debug("Future got status code {}", (Object)response.getStatusCode());
                if (response.getStatusCode() == 200) continue;
                throw new IllegalStateException("Got status code:" + response.getStatusCode());
            }
        }

        private void downloadRemoteArtifact(RemoteArtifact remoteArtifact, ArtifactManager artifactManager, SingularityExecutorTask task) {
            Path fetched = artifactManager.fetch(remoteArtifact);
            if (fetched.getFileName().toString().endsWith(".tar.gz")) {
                artifactManager.untar(fetched, task.getTaskDefinition().getTaskDirectoryPath());
            } else {
                artifactManager.copy(fetched, task.getTaskDefinition().getTaskAppDirectoryPath());
            }
        }
    }
}

