/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor.models;

import com.hubspot.singularity.executor.config.SingularityExecutorConfiguration;
import com.hubspot.singularity.executor.task.SingularityExecutorTaskDefinition;
import java.util.ArrayList;
import java.util.List;

public class LogrotateTemplateContext {
    private final SingularityExecutorTaskDefinition taskDefinition;
    private final SingularityExecutorConfiguration configuration;

    public LogrotateTemplateContext(SingularityExecutorConfiguration configuration, SingularityExecutorTaskDefinition taskDefinition) {
        this.configuration = configuration;
        this.taskDefinition = taskDefinition;
    }

    public String getRotateDateformat() {
        return this.configuration.getLogrotateDateformat();
    }

    public int getRotateCount() {
        return this.configuration.getLogrotateCount();
    }

    public int getMaxageDays() {
        return this.configuration.getLogrotateMaxageDays();
    }

    public String getRotateDirectory() {
        return this.configuration.getLogrotateToDirectory();
    }

    public List<String> getExtrasFiles() {
        List<String> original = this.configuration.getLogrotateAdditionalFiles();
        ArrayList<String> transformed = new ArrayList<String>(original.size());
        for (String filename : original) {
            transformed.add(this.taskDefinition.getTaskDirectoryPath().resolve(filename).toString());
        }
        return transformed;
    }

    public String getExtrasDateformat() {
        return this.configuration.getLogrotateExtrasDateformat();
    }

    public String getLogfile() {
        return this.taskDefinition.getServiceLogOut();
    }

    public String toString() {
        return "LogrotateTemplateContext [taskId=" + this.taskDefinition.getTaskId() + "]";
    }
}

