/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.hubspot.deploy.ExecutorData;
import com.hubspot.mesos.MesosUtils;
import com.hubspot.singularity.executor.TemplateManager;
import com.hubspot.singularity.executor.config.SingularityExecutorConfiguration;
import com.hubspot.singularity.executor.config.SingularityExecutorLogging;
import com.hubspot.singularity.executor.task.SingularityExecutorArtifactFetcher;
import com.hubspot.singularity.executor.task.SingularityExecutorTask;
import com.hubspot.singularity.executor.task.SingularityExecutorTaskDefinition;
import com.hubspot.singularity.executor.utils.ExecutorUtils;
import com.hubspot.singularity.runner.base.configuration.SingularityRunnerBaseConfiguration;
import com.hubspot.singularity.runner.base.shared.JsonObjectFileHelper;
import com.spotify.docker.client.DockerClient;
import java.nio.file.Path;
import org.apache.mesos.ExecutorDriver;
import org.apache.mesos.Protos;
import org.slf4j.Logger;

@Singleton
public class SingularityExecutorTaskBuilder {
    private final ObjectMapper jsonObjectMapper;
    private final TemplateManager templateManager;
    private final SingularityRunnerBaseConfiguration baseConfiguration;
    private final SingularityExecutorConfiguration executorConfiguration;
    private final SingularityExecutorArtifactFetcher artifactFetcher;
    private final DockerClient dockerClient;
    private final SingularityExecutorLogging executorLogging;
    private final ExecutorUtils executorUtils;
    private final String executorPid;
    private final JsonObjectFileHelper jsonObjectFileHelper;

    @Inject
    public SingularityExecutorTaskBuilder(ObjectMapper jsonObjectMapper, JsonObjectFileHelper jsonObjectFileHelper, TemplateManager templateManager, SingularityExecutorLogging executorLogging, SingularityRunnerBaseConfiguration baseConfiguration, SingularityExecutorConfiguration executorConfiguration, @Named(value="process.name") String executorPid, ExecutorUtils executorUtils, SingularityExecutorArtifactFetcher artifactFetcher, DockerClient dockerClient) {
        this.jsonObjectFileHelper = jsonObjectFileHelper;
        this.jsonObjectMapper = jsonObjectMapper;
        this.templateManager = templateManager;
        this.executorLogging = executorLogging;
        this.baseConfiguration = baseConfiguration;
        this.executorConfiguration = executorConfiguration;
        this.artifactFetcher = artifactFetcher;
        this.dockerClient = dockerClient;
        this.executorPid = executorPid;
        this.executorUtils = executorUtils;
    }

    public ch.qos.logback.classic.Logger buildTaskLogger(String taskId) {
        Path javaExecutorLogPath = MesosUtils.getTaskDirectoryPath((String)taskId).resolve(this.executorConfiguration.getExecutorJavaLog());
        return this.executorLogging.buildTaskLogger(taskId, javaExecutorLogPath.toString());
    }

    public SingularityExecutorTask buildTask(String taskId, ExecutorDriver driver, Protos.TaskInfo taskInfo, ch.qos.logback.classic.Logger log) {
        ExecutorData executorData = this.readExecutorData(this.jsonObjectMapper, taskInfo);
        SingularityExecutorTaskDefinition taskDefinition = new SingularityExecutorTaskDefinition(taskId, executorData, MesosUtils.getTaskDirectoryPath((String)taskId).toString(), this.executorPid, this.executorConfiguration.getServiceLog(), this.executorConfiguration.getTaskAppDirectory(), this.executorConfiguration.getExecutorBashLog(), this.executorConfiguration.getLogrotateStateFile());
        this.jsonObjectFileHelper.writeObject((Object)taskDefinition, this.executorConfiguration.getTaskDefinitionPath(taskId), (Logger)log);
        return new SingularityExecutorTask(driver, this.executorUtils, this.baseConfiguration, this.executorConfiguration, taskDefinition, this.executorPid, this.artifactFetcher, taskInfo, this.templateManager, this.jsonObjectMapper, log, this.jsonObjectFileHelper, this.dockerClient);
    }

    private ExecutorData readExecutorData(ObjectMapper objectMapper, Protos.TaskInfo taskInfo) {
        try {
            Preconditions.checkState((boolean)taskInfo.hasData(), (Object)"TaskInfo was missing executor data");
            return (ExecutorData)objectMapper.readValue(taskInfo.getData().toByteArray(), ExecutorData.class);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

