/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.hubspot.mesos.JavaUtils;
import com.hubspot.singularity.executor.SingularityExecutorMonitor;
import com.hubspot.singularity.executor.config.SingularityExecutorConfiguration;
import com.hubspot.singularity.executor.task.SingularityExecutorTaskProcessCallable;
import com.hubspot.singularity.runner.base.shared.ProcessFailedException;
import com.hubspot.singularity.runner.base.shared.SimpleProcessManager;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.DockerException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.NOPLogger;

@Singleton
public class SingularityExecutorThreadChecker {
    private static final Logger LOG = LoggerFactory.getLogger(SingularityExecutorThreadChecker.class);
    private final SingularityExecutorConfiguration configuration;
    private final ScheduledExecutorService scheduledExecutorService;
    private final DockerClient dockerClient;
    private SingularityExecutorMonitor monitor;

    @Inject
    public SingularityExecutorThreadChecker(SingularityExecutorConfiguration configuration, DockerClient dockerClient) {
        this.configuration = configuration;
        this.dockerClient = dockerClient;
        this.scheduledExecutorService = Executors.newScheduledThreadPool(configuration.getThreadCheckThreads(), new ThreadFactoryBuilder().setNameFormat("SingularityExecutorThreadCheckerThread-%d").build());
    }

    public void start(SingularityExecutorMonitor monitor) {
        LOG.info("Starting a thread checker that will run every {}", (Object)JavaUtils.durationFromMillis((long)this.configuration.getCheckThreadsEveryMillis()));
        this.monitor = monitor;
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long start = System.currentTimeMillis();
                try {
                    SingularityExecutorThreadChecker.this.checkThreads();
                }
                catch (Throwable t) {
                    LOG.error("While checking threads", t);
                }
                finally {
                    LOG.trace("Finished checking threads after {}", (Object)JavaUtils.duration((long)start));
                }
            }
        }, this.configuration.getCheckThreadsEveryMillis(), this.configuration.getCheckThreadsEveryMillis(), TimeUnit.MILLISECONDS);
    }

    private void checkThreads() {
        for (SingularityExecutorTaskProcessCallable taskProcess : this.monitor.getRunningTasks()) {
            if (!taskProcess.getTask().getExecutorData().getMaxTaskThreads().isPresent()) continue;
            int maxThreads = (Integer)taskProcess.getTask().getExecutorData().getMaxTaskThreads().get();
            int usedThreads = 0;
            try {
                usedThreads = this.getNumUsedThreads(taskProcess);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                return;
            }
            catch (Throwable t) {
                taskProcess.getTask().getLog().error("While fetching used threads for {}", (Object)taskProcess.getTask().getTaskId(), (Object)t);
                continue;
            }
            if (usedThreads <= maxThreads) continue;
            taskProcess.getTask().getLog().info("{} using too many threads: {} (max {})", new Object[]{taskProcess.getTask().getTaskId(), usedThreads, maxThreads});
            taskProcess.getTask().markKilledDueToThreads(usedThreads);
            SingularityExecutorMonitor.KillState killState = this.monitor.requestKill(taskProcess.getTask().getTaskId());
            taskProcess.getTask().getLog().info("Killing {} due to thread overage (kill state {})", (Object)taskProcess.getTask().getTaskId(), (Object)killState);
        }
    }

    public ExecutorService getExecutorService() {
        return this.scheduledExecutorService;
    }

    private int getNumUsedThreads(SingularityExecutorTaskProcessCallable taskProcess) throws InterruptedException, ProcessFailedException {
        ImmutableList cmd;
        List output;
        SimpleProcessManager checkThreadsProcessManager = new SimpleProcessManager((Logger)NOPLogger.NOP_LOGGER);
        Optional dockerPid = Optional.absent();
        if (taskProcess.getTask().getTaskInfo().hasContainer() && taskProcess.getTask().getTaskInfo().getContainer().hasDocker()) {
            try {
                String containerName = String.format("%s%s", this.configuration.getDockerPrefix(), taskProcess.getTask().getTaskId());
                dockerPid = Optional.of((Object)this.dockerClient.inspectContainer(containerName).state().pid());
            }
            catch (DockerException e) {
                throw new ProcessFailedException(String.format("Could not get docker root pid due to error: %s", new Object[]{e}));
            }
        }
        if ((output = checkThreadsProcessManager.runCommandWithOutput((List)(cmd = ImmutableList.of((Object)"/bin/sh", (Object)"-c", (Object)String.format("pstree %s -p | wc -l", dockerPid.or(taskProcess.getCurrentPid().get())))))).isEmpty()) {
            throw new ProcessFailedException("Output from ps was empty");
        }
        return Integer.parseInt((String)output.get(0));
    }
}

