/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.hubspot.singularity.executor.SingularityExecutorMonitor;
import com.hubspot.singularity.executor.config.SingularityExecutorTaskBuilder;
import com.hubspot.singularity.executor.task.SingularityExecutorTask;
import com.hubspot.singularity.executor.utils.ExecutorUtils;
import java.nio.charset.StandardCharsets;
import org.apache.mesos.Executor;
import org.apache.mesos.ExecutorDriver;
import org.apache.mesos.Protos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingularityExecutor
implements Executor {
    private static final Logger LOG = LoggerFactory.getLogger(SingularityExecutor.class);
    private final SingularityExecutorTaskBuilder taskBuilder;
    private final SingularityExecutorMonitor monitor;
    private final ExecutorUtils executorUtils;

    @Inject
    public SingularityExecutor(SingularityExecutorMonitor monitor, ExecutorUtils executorUtils, SingularityExecutorTaskBuilder taskBuilder) {
        this.taskBuilder = taskBuilder;
        this.monitor = monitor;
        this.executorUtils = executorUtils;
    }

    public void registered(ExecutorDriver executorDriver, Protos.ExecutorInfo executorInfo, Protos.FrameworkInfo frameworkInfo, Protos.SlaveInfo slaveInfo) {
        LOG.info("Registered {} with Mesos slave {} for framework {}", new Object[]{executorInfo, slaveInfo, frameworkInfo});
    }

    public void reregistered(ExecutorDriver executorDriver, Protos.SlaveInfo slaveInfo) {
        LOG.info("Re-registered with Mesos slave {}", (Object)slaveInfo);
    }

    public void disconnected(ExecutorDriver executorDriver) {
        LOG.warn("Disconnected from Mesos slave");
    }

    public void launchTask(ExecutorDriver executorDriver, Protos.TaskInfo taskInfo) {
        String taskId = taskInfo.getTaskId().getValue();
        LOG.info("Asked to launch task {}", (Object)taskId);
        try {
            ch.qos.logback.classic.Logger taskLog = this.taskBuilder.buildTaskLogger(taskId);
            SingularityExecutorTask task = this.taskBuilder.buildTask(taskId, executorDriver, taskInfo, taskLog);
            SingularityExecutorMonitor.SubmitState submitState = this.monitor.submit(task);
            switch (submitState) {
                case REJECTED: {
                    LOG.warn("Can't launch task {}, it was rejected (probably due to shutdown)", (Object)taskInfo);
                    break;
                }
                case TASK_ALREADY_EXISTED: {
                    LOG.error("Can't launch task {}, already had a task with that ID", (Object)taskInfo);
                    break;
                }
                case SUBMITTED: {
                    task.getLog().info("Launched task {} with data {}", (Object)taskId, (Object)task.getExecutorData());
                }
            }
        }
        catch (Throwable t) {
            LOG.error("Unexpected exception starting task {}", (Object)taskId, (Object)t);
            this.executorUtils.sendStatusUpdate(executorDriver, taskInfo, Protos.TaskState.TASK_LOST, String.format("Unexpected exception while launching task %s - %s", taskId, t.getMessage()), LOG);
        }
    }

    public void killTask(ExecutorDriver executorDriver, Protos.TaskID taskID) {
        String taskId = taskID.getValue();
        LOG.info("Asked to kill task {}", (Object)taskId);
        SingularityExecutorMonitor.KillState killState = this.monitor.requestKill(taskId);
        switch (killState) {
            case DIDNT_EXIST: 
            case INCONSISTENT_STATE: {
                LOG.warn("Couldn't kill task {} due to killState {}", (Object)taskId, (Object)killState);
                break;
            }
            case DESTROYING_PROCESS: 
            case INTERRUPTING_PRE_PROCESS: 
            case KILLING_PROCESS: {
                LOG.info("Requested kill of task {} with killState {}", (Object)taskId, (Object)killState);
            }
        }
    }

    public void frameworkMessage(ExecutorDriver executorDriver, byte[] bytes) {
        LOG.info("Received framework message: {}", (Object)new String(bytes, StandardCharsets.UTF_8));
    }

    public void shutdown(ExecutorDriver executorDriver) {
        LOG.info("Asked to shutdown executor...");
        this.monitor.shutdown((Optional<ExecutorDriver>)Optional.of((Object)executorDriver));
    }

    public void error(ExecutorDriver executorDriver, String s) {
        LOG.error("Executor error: {}", (Object)s);
    }
}

