/*
 * Decompiled with CFR 0.152.
 */
package net.kencochrane.raven.event;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.kencochrane.raven.event.interfaces.SentryInterface;

public class Event
implements Serializable {
    private final UUID id;
    private String message;
    private Date timestamp;
    private Level level;
    private String logger;
    private String platform;
    private String culprit;
    private Map<String, String> tags = new HashMap<String, String>();
    private String serverName;
    private transient Map<String, Object> extra = new HashMap<String, Object>();
    private String checksum;
    private Map<String, SentryInterface> sentryInterfaces = new HashMap<String, SentryInterface>();

    Event(UUID id) {
        if (id == null) {
            throw new IllegalArgumentException("The id can't be null");
        }
        this.id = id;
    }

    public UUID getId() {
        return this.id;
    }

    public String getMessage() {
        return this.message;
    }

    void setMessage(String message) {
        this.message = message;
    }

    public Date getTimestamp() {
        return this.timestamp != null ? (Date)this.timestamp.clone() : null;
    }

    void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public Level getLevel() {
        return this.level;
    }

    void setLevel(Level level) {
        this.level = level;
    }

    public String getLogger() {
        return this.logger;
    }

    void setLogger(String logger2) {
        this.logger = logger2;
    }

    public String getPlatform() {
        return this.platform;
    }

    void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getCulprit() {
        return this.culprit;
    }

    void setCulprit(String culprit) {
        this.culprit = culprit;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public String getServerName() {
        return this.serverName;
    }

    void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public Map<String, Object> getExtra() {
        return this.extra;
    }

    void setExtra(Map<String, Object> extra) {
        this.extra = extra;
    }

    public String getChecksum() {
        return this.checksum;
    }

    void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public Map<String, SentryInterface> getSentryInterfaces() {
        return this.sentryInterfaces;
    }

    void setSentryInterfaces(Map<String, SentryInterface> sentryInterfaces) {
        this.sentryInterfaces = sentryInterfaces;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.extra = (Map)stream.readObject();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeObject(Event.convertToSerializable(this.extra));
    }

    private static HashMap<String, ? super Serializable> convertToSerializable(Map<String, Object> objectMap) {
        HashMap<String, Object> serializableMap = new HashMap<String, Object>(objectMap.size());
        for (Map.Entry<String, Object> objectEntry : objectMap.entrySet()) {
            if (objectEntry.getValue() instanceof Serializable) {
                serializableMap.put(objectEntry.getKey(), (Serializable)objectEntry.getValue());
                continue;
            }
            serializableMap.put(objectEntry.getKey(), objectEntry.getValue().toString());
        }
        return serializableMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.id.equals(((Event)o).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "Event{level=" + (Object)((Object)this.level) + ", message='" + this.message + '\'' + ", logger='" + this.logger + '\'' + '}';
    }

    public static enum Level {
        FATAL,
        ERROR,
        WARNING,
        INFO,
        DEBUG;

    }
}

