/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.util;

import com.google.common.base.Optional;
import java.io.File;
import java.net.URL;

public class JarLocation {
    private final Class<?> klass;

    public JarLocation(Class<?> klass) {
        this.klass = klass;
    }

    public Optional<String> getVersion() {
        Package pkg = this.klass.getPackage();
        if (pkg == null) {
            return Optional.absent();
        }
        return Optional.fromNullable(pkg.getImplementationVersion());
    }

    public String toString() {
        URL location = this.klass.getProtectionDomain().getCodeSource().getLocation();
        try {
            String jar = new File(location.toURI()).getName();
            if (jar.endsWith(".jar")) {
                return jar;
            }
            return "project.jar";
        }
        catch (Exception ignored) {
            return "project.jar";
        }
    }
}

