/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.s3.base;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.hubspot.deploy.S3Artifact;

public class ArtifactDownloadRequest {
    private final String targetDirectory;
    private final S3Artifact s3Artifact;

    @JsonCreator
    public ArtifactDownloadRequest(@JsonProperty(value="targetDirectory") String targetDirectory, @JsonProperty(value="s3Artifact") S3Artifact s3Artifact) {
        Preconditions.checkNotNull(targetDirectory);
        Preconditions.checkNotNull(s3Artifact);
        this.targetDirectory = targetDirectory;
        this.s3Artifact = s3Artifact;
    }

    public String getTargetDirectory() {
        return this.targetDirectory;
    }

    public S3Artifact getS3Artifact() {
        return this.s3Artifact;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.s3Artifact == null ? 0 : this.s3Artifact.hashCode());
        result = 31 * result + (this.targetDirectory == null ? 0 : this.targetDirectory.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArtifactDownloadRequest other = (ArtifactDownloadRequest)obj;
        if (this.s3Artifact == null ? other.s3Artifact != null : !this.s3Artifact.equals(other.s3Artifact)) {
            return false;
        }
        return !(this.targetDirectory == null ? other.targetDirectory != null : !this.targetDirectory.equals(other.targetDirectory));
    }

    public String toString() {
        return "ArtifactDownloadRequest [targetDirectory=" + this.targetDirectory + ", s3Artifact=" + this.s3Artifact + "]";
    }
}

