/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor.task;

import com.google.common.collect.ImmutableList;
import com.hubspot.singularity.executor.config.SingularityExecutorConfiguration;
import com.hubspot.singularity.executor.task.SingularityExecutorTaskDefinition;
import com.hubspot.singularity.executor.task.SingularityExecutorTaskLogManager;
import com.hubspot.singularity.executor.task.TaskCleanupResult;
import com.hubspot.singularity.executor.utils.DockerUtils;
import com.hubspot.singularity.runner.base.shared.SimpleProcessManager;
import com.spotify.docker.client.ContainerNotFoundException;
import com.spotify.docker.client.messages.ContainerInfo;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;

public class SingularityExecutorTaskCleanup {
    private final SingularityExecutorTaskDefinition taskDefinition;
    private final SingularityExecutorTaskLogManager taskLogManager;
    private final SingularityExecutorConfiguration configuration;
    private final Logger log;
    private final DockerUtils dockerUtils;

    public SingularityExecutorTaskCleanup(SingularityExecutorTaskLogManager taskLogManager, SingularityExecutorConfiguration configuration, SingularityExecutorTaskDefinition taskDefinition, Logger log, DockerUtils dockerUtils) {
        this.configuration = configuration;
        this.taskLogManager = taskLogManager;
        this.taskDefinition = taskDefinition;
        this.log = log;
        this.dockerUtils = dockerUtils;
    }

    public TaskCleanupResult cleanup(boolean cleanupTaskAppDirectory, boolean isDocker) {
        Path taskDirectory = Paths.get(this.taskDefinition.getTaskDirectory(), new String[0]);
        boolean dockerCleanSuccess = true;
        if (isDocker) {
            try {
                String containerName = String.format("%s%s", this.configuration.getDockerPrefix(), this.taskDefinition.getTaskId());
                ContainerInfo containerInfo = this.dockerUtils.inspectContainer(containerName);
                if (containerInfo.state().running().booleanValue()) {
                    this.dockerUtils.stopContainer(containerName, this.configuration.getDockerStopTimeout());
                }
                this.dockerUtils.removeContainer(containerName, true);
            }
            catch (ContainerNotFoundException e) {
                this.log.trace("Container for task {} was already removed", (Object)this.taskDefinition.getTaskId());
            }
            catch (Exception e) {
                this.log.error("Could not ensure removal of container", e);
                dockerCleanSuccess = false;
            }
        }
        if (!Files.exists(taskDirectory, new LinkOption[0])) {
            this.log.info("Directory {} didn't exist for cleanup", (Object)taskDirectory);
            this.taskLogManager.removeLogrotateFile();
            return this.finishTaskCleanup(dockerCleanSuccess);
        }
        boolean logTearDownSuccess = this.taskLogManager.teardown();
        if (!cleanupTaskAppDirectory) {
            this.log.info("Not finishing cleanup because taskApp directory is being preserved");
            return TaskCleanupResult.WAITING;
        }
        boolean cleanupTaskAppDirectorySuccess = this.cleanupTaskAppDirectory();
        this.log.info("Cleaned up logs ({}) and task app directory ({})", (Object)logTearDownSuccess, (Object)cleanupTaskAppDirectorySuccess);
        if (logTearDownSuccess && cleanupTaskAppDirectorySuccess) {
            return this.finishTaskCleanup(dockerCleanSuccess);
        }
        return TaskCleanupResult.ERROR;
    }

    private TaskCleanupResult finishTaskCleanup(boolean dockerCleanSuccess) {
        boolean cleanTaskDefinitionFile = this.cleanTaskDefinitionFile();
        if (cleanTaskDefinitionFile && dockerCleanSuccess) {
            return TaskCleanupResult.SUCCESS;
        }
        return TaskCleanupResult.ERROR;
    }

    public boolean cleanTaskDefinitionFile() {
        Path taskDefinitionPath = this.configuration.getTaskDefinitionPath(this.taskDefinition.getTaskId());
        this.log.info("Successful cleanup, deleting file {}", (Object)taskDefinitionPath);
        try {
            boolean deleted = Files.deleteIfExists(taskDefinitionPath);
            this.log.info("File deleted ({})", (Object)deleted);
            return true;
        }
        catch (IOException e) {
            this.log.error("Failed deleting {}", (Object)taskDefinitionPath, (Object)e);
            return false;
        }
    }

    private boolean cleanupTaskAppDirectory() {
        String pathToDelete = this.taskDefinition.getTaskAppDirectory();
        this.log.info("Deleting: {}", (Object)pathToDelete);
        try {
            ImmutableList<String> cmd = ImmutableList.of("rm", "-rf", pathToDelete);
            new SimpleProcessManager(this.log).runCommand(cmd);
            return true;
        }
        catch (Throwable t) {
            this.log.error("While deleting directory {}", (Object)pathToDelete, (Object)t);
            return false;
        }
    }
}

