/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor.models;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import com.hubspot.singularity.executor.config.SingularityExecutorConfiguration;
import com.hubspot.singularity.executor.config.SingularityExecutorLogrotateAdditionalFile;
import com.hubspot.singularity.executor.models.LogrotateAdditionalFile;
import com.hubspot.singularity.executor.task.SingularityExecutorTaskDefinition;
import java.util.ArrayList;
import java.util.List;

public class LogrotateTemplateContext {
    private final SingularityExecutorTaskDefinition taskDefinition;
    private final SingularityExecutorConfiguration configuration;

    public LogrotateTemplateContext(SingularityExecutorConfiguration configuration, SingularityExecutorTaskDefinition taskDefinition) {
        this.configuration = configuration;
        this.taskDefinition = taskDefinition;
    }

    public String getRotateDateformat() {
        return this.configuration.getLogrotateDateformat();
    }

    public int getRotateCount() {
        return this.configuration.getLogrotateCount();
    }

    public int getMaxageDays() {
        return this.configuration.getLogrotateMaxageDays();
    }

    public String getRotateDirectory() {
        return this.configuration.getLogrotateToDirectory();
    }

    public boolean getShouldLogRotateLogFile() {
        return this.taskDefinition.shouldLogrotateLogFile();
    }

    public List<LogrotateAdditionalFile> getExtrasFiles() {
        List<SingularityExecutorLogrotateAdditionalFile> original = this.configuration.getLogrotateAdditionalFiles();
        ArrayList<LogrotateAdditionalFile> transformed = new ArrayList<LogrotateAdditionalFile>(original.size());
        for (SingularityExecutorLogrotateAdditionalFile additionalFile : original) {
            transformed.add(new LogrotateAdditionalFile(this.taskDefinition.getTaskDirectoryPath().resolve(additionalFile.getFilename()).toString(), additionalFile.getExtension().or(Strings.emptyToNull(Files.getFileExtension(additionalFile.getFilename()))), additionalFile.getDateformat().or(this.configuration.getLogrotateExtrasDateformat())));
        }
        return transformed;
    }

    private Optional<String> parseFilenameExtension(String filename) {
        int lastPeriodIndex = filename.lastIndexOf(46);
        if (lastPeriodIndex > -1 && !filename.substring(lastPeriodIndex + 1).contains("*")) {
            return Optional.of(filename.substring(lastPeriodIndex + 1));
        }
        return Optional.absent();
    }

    public String getExtrasDateformat() {
        return this.configuration.getLogrotateExtrasDateformat();
    }

    public String getLogfile() {
        return this.taskDefinition.getServiceLogOut();
    }

    public String getLogfileExtension() {
        return this.taskDefinition.getServiceLogOutExtension();
    }

    public String toString() {
        return "LogrotateTemplateContext [taskId=" + this.taskDefinition.getTaskId() + "]";
    }
}

