/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.mesos.JavaUtils;
import com.hubspot.singularity.WebhookType;
import com.wordnik.swagger.annotations.ApiModelProperty;

public class SingularityWebhook {
    private final String uri;
    private final WebhookType type;
    private final Optional<String> user;
    private final long timestamp;
    private final String id;

    @JsonCreator
    public SingularityWebhook(@JsonProperty(value="uri") String uri, @JsonProperty(value="timestamp") Optional<Long> timestamp, @JsonProperty(value="user") Optional<String> user, @JsonProperty(value="type") WebhookType type) {
        this.uri = uri;
        this.timestamp = timestamp.or(System.currentTimeMillis());
        this.user = user;
        this.id = type.name() + "-" + JavaUtils.urlEncode(uri);
        this.type = type;
    }

    @ApiModelProperty(required=false, value="Unique ID for webhook.")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(value="URI to POST to.")
    public String getUri() {
        return this.uri;
    }

    @ApiModelProperty(required=false, value="")
    public long getTimestamp() {
        return this.timestamp;
    }

    @ApiModelProperty(required=false, value="User that created webhook.")
    public Optional<String> getUser() {
        return this.user;
    }

    @ApiModelProperty(value="Webhook type.")
    public WebhookType getType() {
        return this.type;
    }

    public String toString() {
        return "SingularityWebhook [uri=" + this.uri + ", timestamp=" + this.timestamp + ", id=" + this.id + ", user=" + this.user + ", type=" + (Object)((Object)this.type) + "]";
    }
}

