/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.singularity.SingularityId;
import com.hubspot.singularity.SingularityTaskId;

public class SingularityTaskShellCommandRequestId
extends SingularityId {
    private final SingularityTaskId taskId;
    private final String name;
    private final String safeName;
    private final long timestamp;

    @JsonCreator
    public SingularityTaskShellCommandRequestId(@JsonProperty(value="taskId") SingularityTaskId taskId, @JsonProperty(value="name") String name, @JsonProperty(value="timestamp") long timestamp) {
        this.taskId = taskId;
        this.timestamp = timestamp;
        this.name = name;
        this.safeName = name.replace("/", "");
    }

    @Override
    @JsonIgnore
    public String getId() {
        return String.format("%s-%s", this.getTaskId(), this.getSubIdForTaskHistory());
    }

    @JsonIgnore
    public String getSubIdForTaskHistory() {
        return String.format("%s-%s", this.safeName, this.getTimestamp());
    }

    public SingularityTaskId getTaskId() {
        return this.taskId;
    }

    public String getName() {
        return this.name;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return "SingularityTaskShellCommandRequestId [taskId=" + this.taskId + ", name=" + this.name + ", timestamp=" + this.timestamp + "]";
    }
}

