/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Iterables;
import com.hubspot.singularity.ExtendedTaskState;
import com.hubspot.singularity.SingularityTask;
import com.hubspot.singularity.SingularityTaskHistoryUpdate;
import com.hubspot.singularity.SingularityTaskId;
import java.util.List;

public class SingularityTaskIdHistory
implements Comparable<SingularityTaskIdHistory> {
    private final SingularityTaskId taskId;
    private final long updatedAt;
    private final Optional<ExtendedTaskState> lastTaskState;
    private final Optional<String> runId;

    public static SingularityTaskIdHistory fromTaskIdAndTaskAndUpdates(SingularityTaskId taskId, SingularityTask task, List<SingularityTaskHistoryUpdate> updates) {
        ExtendedTaskState lastTaskState = null;
        long updatedAt = taskId.getStartedAt();
        if (updates != null && !updates.isEmpty()) {
            SingularityTaskHistoryUpdate lastUpdate = Iterables.getLast(updates);
            lastTaskState = lastUpdate.getTaskState();
            updatedAt = lastUpdate.getTimestamp();
        }
        return new SingularityTaskIdHistory(taskId, updatedAt, Optional.fromNullable(lastTaskState), task.getTaskRequest().getPendingTask().getRunId());
    }

    @JsonCreator
    public SingularityTaskIdHistory(@JsonProperty(value="taskId") SingularityTaskId taskId, @JsonProperty(value="updatedAt") long updatedAt, @JsonProperty(value="lastStatus") Optional<ExtendedTaskState> lastTaskState, @JsonProperty(value="runId") Optional<String> runId) {
        this.taskId = taskId;
        this.updatedAt = updatedAt;
        this.lastTaskState = lastTaskState;
        this.runId = runId;
    }

    @Override
    public int compareTo(SingularityTaskIdHistory o) {
        return ComparisonChain.start().compare(o.getUpdatedAt(), this.updatedAt).compare((Comparable<?>)((Object)this.taskId.getId()), (Comparable<?>)((Object)o.getTaskId().getId())).result();
    }

    public int hashCode() {
        return Objects.hashCode(this.taskId, this.updatedAt, this.lastTaskState, this.runId);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        SingularityTaskIdHistory that = (SingularityTaskIdHistory)other;
        return Objects.equal(this.taskId, that.taskId) && Objects.equal(this.updatedAt, that.updatedAt) && Objects.equal(this.lastTaskState, that.lastTaskState) && Objects.equal(this.runId, that.runId);
    }

    public SingularityTaskId getTaskId() {
        return this.taskId;
    }

    public Optional<ExtendedTaskState> getLastTaskState() {
        return this.lastTaskState;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    public Optional<String> getRunId() {
        return this.runId;
    }

    public String toString() {
        return "SingularityTaskIdHistory [taskId=" + this.taskId + ", updatedAt=" + this.updatedAt + ", lastTaskState=" + this.lastTaskState + ", runId=" + this.runId + "]";
    }
}

