/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.mesos.MesosUtils;
import com.hubspot.singularity.SingularityTaskId;
import com.hubspot.singularity.SingularityTaskIdHolder;
import com.hubspot.singularity.SingularityTaskRequest;
import java.util.List;
import org.apache.mesos.Protos;

public class SingularityTask
extends SingularityTaskIdHolder {
    private final SingularityTaskRequest taskRequest;
    private final Protos.Offer offer;
    private final Protos.TaskInfo mesosTask;
    private final Optional<String> rackId;

    @JsonCreator
    public SingularityTask(@JsonProperty(value="taskRequest") SingularityTaskRequest taskRequest, @JsonProperty(value="taskId") SingularityTaskId taskId, @JsonProperty(value="offer") Protos.Offer offer, @JsonProperty(value="mesosTask") Protos.TaskInfo task, @JsonProperty(value="rackId") Optional<String> rackId) {
        super(taskId);
        this.taskRequest = taskRequest;
        this.offer = offer;
        this.mesosTask = task;
        this.rackId = rackId;
    }

    public SingularityTaskRequest getTaskRequest() {
        return this.taskRequest;
    }

    public Protos.Offer getOffer() {
        return this.offer;
    }

    public Protos.TaskInfo getMesosTask() {
        return this.mesosTask;
    }

    public Optional<String> getRackId() {
        return this.rackId;
    }

    @JsonIgnore
    public Optional<Long> getPortByIndex(int index) {
        List<Long> ports = MesosUtils.getAllPorts(this.mesosTask.getResourcesList());
        if (index >= ports.size() || index < 0) {
            return Optional.absent();
        }
        return Optional.of(ports.get(index));
    }

    public String toString() {
        return "SingularityTask [taskRequest=" + this.taskRequest + ", offer=" + this.offer + ", mesosTask=" + this.mesosTask + ", rackId=" + this.rackId + "]";
    }
}

