/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.hubspot.singularity.RequestType;
import com.hubspot.singularity.ScheduleType;
import com.hubspot.singularity.SingularityEmailDestination;
import com.hubspot.singularity.SingularityEmailType;
import com.hubspot.singularity.SingularityRequest;
import com.hubspot.singularity.SlavePlacement;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class SingularityRequestBuilder {
    private final String id;
    private final RequestType requestType;
    private Optional<List<String>> owners;
    private Optional<Integer> numRetriesOnFailure;
    private Optional<String> schedule;
    private Optional<String> quartzSchedule;
    private Optional<ScheduleType> scheduleType;
    private Optional<Long> killOldNonLongRunningTasksAfterMillis;
    private Optional<Long> scheduledExpectedRuntimeMillis;
    private Optional<Long> waitAtLeastMillisAfterTaskFinishesForReschedule;
    private Optional<Integer> instances;
    private Optional<Boolean> skipHealthchecks;
    private Optional<Boolean> rackSensitive;
    private Optional<List<String>> rackAffinity;
    private Optional<SlavePlacement> slavePlacement;
    private Optional<Map<String, String>> requiredSlaveAttributes;
    private Optional<Map<String, String>> allowedSlaveAttributes;
    private Optional<Boolean> loadBalanced;
    private Optional<String> group;
    private Optional<Set<String>> readOnlyGroups;
    private Optional<Boolean> bounceAfterScale;
    private Optional<Map<SingularityEmailType, List<SingularityEmailDestination>>> emailConfigurationOverrides;

    public SingularityRequestBuilder(String id, RequestType requestType) {
        this.id = Preconditions.checkNotNull(id, "id cannot be null");
        this.requestType = Preconditions.checkNotNull(requestType, "requestType cannot be null");
        this.owners = Optional.absent();
        this.numRetriesOnFailure = Optional.absent();
        this.schedule = Optional.absent();
        this.scheduleType = Optional.absent();
        this.killOldNonLongRunningTasksAfterMillis = Optional.absent();
        this.instances = Optional.absent();
        this.rackSensitive = Optional.absent();
        this.loadBalanced = Optional.absent();
        this.quartzSchedule = Optional.absent();
        this.rackAffinity = Optional.absent();
        this.slavePlacement = Optional.absent();
        this.requiredSlaveAttributes = Optional.absent();
        this.allowedSlaveAttributes = Optional.absent();
        this.scheduledExpectedRuntimeMillis = Optional.absent();
        this.waitAtLeastMillisAfterTaskFinishesForReschedule = Optional.absent();
        this.group = Optional.absent();
        this.readOnlyGroups = Optional.absent();
        this.bounceAfterScale = Optional.absent();
        this.emailConfigurationOverrides = Optional.absent();
        this.skipHealthchecks = Optional.absent();
    }

    public SingularityRequest build() {
        return new SingularityRequest(this.id, this.requestType, this.owners, this.numRetriesOnFailure, this.schedule, this.instances, this.rackSensitive, this.loadBalanced, this.killOldNonLongRunningTasksAfterMillis, this.scheduleType, this.quartzSchedule, this.rackAffinity, this.slavePlacement, this.requiredSlaveAttributes, this.allowedSlaveAttributes, this.scheduledExpectedRuntimeMillis, this.waitAtLeastMillisAfterTaskFinishesForReschedule, this.group, this.readOnlyGroups, this.bounceAfterScale, this.skipHealthchecks, this.emailConfigurationOverrides, Optional.absent());
    }

    public Optional<Boolean> getSkipHealthchecks() {
        return this.skipHealthchecks;
    }

    public SingularityRequestBuilder setSkipHealthchecks(Optional<Boolean> skipHealthchecks) {
        this.skipHealthchecks = skipHealthchecks;
        return this;
    }

    public Optional<Boolean> getLoadBalanced() {
        return this.loadBalanced;
    }

    public SingularityRequestBuilder setLoadBalanced(Optional<Boolean> loadBalanced) {
        this.loadBalanced = loadBalanced;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public Optional<List<String>> getOwners() {
        return this.owners;
    }

    public SingularityRequestBuilder setOwners(Optional<List<String>> owners) {
        this.owners = owners;
        return this;
    }

    public Optional<Integer> getNumRetriesOnFailure() {
        return this.numRetriesOnFailure;
    }

    public SingularityRequestBuilder setNumRetriesOnFailure(Optional<Integer> numRetriesOnFailure) {
        this.numRetriesOnFailure = numRetriesOnFailure;
        return this;
    }

    public Optional<String> getSchedule() {
        return this.schedule;
    }

    public SingularityRequestBuilder setSchedule(Optional<String> schedule) {
        this.schedule = schedule;
        return this;
    }

    public Optional<Integer> getInstances() {
        return this.instances;
    }

    public SingularityRequestBuilder setInstances(Optional<Integer> instances) {
        this.instances = instances;
        return this;
    }

    public Optional<Boolean> getRackSensitive() {
        return this.rackSensitive;
    }

    public SingularityRequestBuilder setRackSensitive(Optional<Boolean> rackSensitive) {
        this.rackSensitive = rackSensitive;
        return this;
    }

    public Optional<Long> getKillOldNonLongRunningTasksAfterMillis() {
        return this.killOldNonLongRunningTasksAfterMillis;
    }

    public SingularityRequestBuilder setKillOldNonLongRunningTasksAfterMillis(Optional<Long> killOldNonLongRunningTasksAfterMillis) {
        this.killOldNonLongRunningTasksAfterMillis = killOldNonLongRunningTasksAfterMillis;
        return this;
    }

    public Optional<ScheduleType> getScheduleType() {
        return this.scheduleType;
    }

    public SingularityRequestBuilder setScheduleType(Optional<ScheduleType> scheduleType) {
        this.scheduleType = scheduleType;
        return this;
    }

    public Optional<String> getQuartzSchedule() {
        return this.quartzSchedule;
    }

    public SingularityRequestBuilder setQuartzSchedule(Optional<String> quartzSchedule) {
        this.quartzSchedule = quartzSchedule;
        return this;
    }

    public Optional<List<String>> getRackAffinity() {
        return this.rackAffinity;
    }

    public SingularityRequestBuilder setRackAffinity(Optional<List<String>> rackAffinity) {
        this.rackAffinity = rackAffinity;
        return this;
    }

    public Optional<SlavePlacement> getSlavePlacement() {
        return this.slavePlacement;
    }

    public SingularityRequestBuilder setSlavePlacement(Optional<SlavePlacement> slavePlacement) {
        this.slavePlacement = slavePlacement;
        return this;
    }

    public Optional<Long> getScheduledExpectedRuntimeMillis() {
        return this.scheduledExpectedRuntimeMillis;
    }

    public SingularityRequestBuilder setScheduledExpectedRuntimeMillis(Optional<Long> scheduledExpectedRuntimeMillis) {
        this.scheduledExpectedRuntimeMillis = scheduledExpectedRuntimeMillis;
        return this;
    }

    public RequestType getRequestType() {
        return this.requestType;
    }

    public Optional<Long> getWaitAtLeastMillisAfterTaskFinishesForReschedule() {
        return this.waitAtLeastMillisAfterTaskFinishesForReschedule;
    }

    public SingularityRequestBuilder setWaitAtLeastMillisAfterTaskFinishesForReschedule(Optional<Long> waitAtLeastMillisAfterTaskFinishesForReschedule) {
        this.waitAtLeastMillisAfterTaskFinishesForReschedule = waitAtLeastMillisAfterTaskFinishesForReschedule;
        return this;
    }

    public Optional<String> getGroup() {
        return this.group;
    }

    public SingularityRequestBuilder setGroup(Optional<String> group) {
        this.group = group;
        return this;
    }

    public SingularityRequestBuilder setRequiredSlaveAttributes(Optional<Map<String, String>> requiredSlaveAttributes) {
        this.requiredSlaveAttributes = requiredSlaveAttributes;
        return this;
    }

    public SingularityRequestBuilder setAllowedSlaveAttributes(Optional<Map<String, String>> allowedSlaveAttributes) {
        this.allowedSlaveAttributes = allowedSlaveAttributes;
        return this;
    }

    public Optional<Set<String>> getReadOnlyGroups() {
        return this.readOnlyGroups;
    }

    public SingularityRequestBuilder setReadOnlyGroups(Optional<Set<String>> readOnlyGroups) {
        this.readOnlyGroups = readOnlyGroups;
        return this;
    }

    public Optional<Boolean> getBounceAfterScale() {
        return this.bounceAfterScale;
    }

    public SingularityRequestBuilder setBounceAfterScale(Optional<Boolean> bounceAfterScale) {
        this.bounceAfterScale = bounceAfterScale;
        return this;
    }

    public Optional<Map<SingularityEmailType, List<SingularityEmailDestination>>> getEmailConfigurationOverrides() {
        return this.emailConfigurationOverrides;
    }

    public SingularityRequestBuilder setEmailConfigurationOverrides(Optional<Map<SingularityEmailType, List<SingularityEmailDestination>>> emailConfigurationOverrides) {
        this.emailConfigurationOverrides = emailConfigurationOverrides;
        return this;
    }

    public String toString() {
        return "SingularityRequestBuilder[id='" + this.id + '\'' + ", requestType=" + (Object)((Object)this.requestType) + ", owners=" + this.owners + ", numRetriesOnFailure=" + this.numRetriesOnFailure + ", schedule=" + this.schedule + ", quartzSchedule=" + this.quartzSchedule + ", scheduleType=" + this.scheduleType + ", killOldNonLongRunningTasksAfterMillis=" + this.killOldNonLongRunningTasksAfterMillis + ", scheduledExpectedRuntimeMillis=" + this.scheduledExpectedRuntimeMillis + ", waitAtLeastMillisAfterTaskFinishesForReschedule=" + this.waitAtLeastMillisAfterTaskFinishesForReschedule + ", instances=" + this.instances + ", rackSensitive=" + this.rackSensitive + ", rackAffinity=" + this.rackAffinity + ", slavePlacement=" + this.slavePlacement + ", requiredSlaveAttrbiutes=" + this.requiredSlaveAttributes + ", allowedSlaveAttrbiutes=" + this.allowedSlaveAttributes + ", loadBalanced=" + this.loadBalanced + ", group=" + this.group + ", readOnlyGroups=" + this.readOnlyGroups + ", bounceAfterScale=" + this.bounceAfterScale + ", emailConfigurationOverrides=" + this.emailConfigurationOverrides + ", skipHealthchecks=" + this.skipHealthchecks + ']';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingularityRequestBuilder that = (SingularityRequestBuilder)o;
        return Objects.equals(this.id, that.id) && Objects.equals((Object)this.requestType, (Object)that.requestType) && Objects.equals(this.owners, that.owners) && Objects.equals(this.numRetriesOnFailure, that.numRetriesOnFailure) && Objects.equals(this.schedule, that.schedule) && Objects.equals(this.quartzSchedule, that.quartzSchedule) && Objects.equals(this.scheduleType, that.scheduleType) && Objects.equals(this.killOldNonLongRunningTasksAfterMillis, that.killOldNonLongRunningTasksAfterMillis) && Objects.equals(this.scheduledExpectedRuntimeMillis, that.scheduledExpectedRuntimeMillis) && Objects.equals(this.waitAtLeastMillisAfterTaskFinishesForReschedule, that.waitAtLeastMillisAfterTaskFinishesForReschedule) && Objects.equals(this.instances, that.instances) && Objects.equals(this.rackSensitive, that.rackSensitive) && Objects.equals(this.rackAffinity, that.rackAffinity) && Objects.equals(this.slavePlacement, that.slavePlacement) && Objects.equals(this.requiredSlaveAttributes, that.requiredSlaveAttributes) && Objects.equals(this.allowedSlaveAttributes, that.allowedSlaveAttributes) && Objects.equals(this.loadBalanced, that.loadBalanced) && Objects.equals(this.group, that.group) && Objects.equals(this.readOnlyGroups, that.readOnlyGroups) && Objects.equals(this.bounceAfterScale, that.bounceAfterScale) && Objects.equals(this.skipHealthchecks, that.skipHealthchecks) && Objects.equals(this.emailConfigurationOverrides, that.emailConfigurationOverrides);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.requestType, this.owners, this.numRetriesOnFailure, this.schedule, this.quartzSchedule, this.scheduleType, this.killOldNonLongRunningTasksAfterMillis, this.scheduledExpectedRuntimeMillis, this.waitAtLeastMillisAfterTaskFinishesForReschedule, this.instances, this.rackSensitive, this.rackAffinity, this.slavePlacement, this.requiredSlaveAttributes, this.allowedSlaveAttributes, this.loadBalanced, this.group, this.readOnlyGroups, this.bounceAfterScale, this.skipHealthchecks, this.emailConfigurationOverrides});
    }
}

