/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.hubspot.singularity.JsonHelpers;
import com.hubspot.singularity.RequestType;
import com.hubspot.singularity.ScheduleType;
import com.hubspot.singularity.SingularityEmailDestination;
import com.hubspot.singularity.SingularityEmailType;
import com.hubspot.singularity.SingularityRequestBuilder;
import com.hubspot.singularity.SlavePlacement;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class SingularityRequest {
    private final String id;
    private final RequestType requestType;
    private final Optional<List<String>> owners;
    private final Optional<Integer> numRetriesOnFailure;
    private final Optional<String> schedule;
    private final Optional<String> quartzSchedule;
    private final Optional<ScheduleType> scheduleType;
    private final Optional<Long> killOldNonLongRunningTasksAfterMillis;
    private final Optional<Long> scheduledExpectedRuntimeMillis;
    private final Optional<Long> waitAtLeastMillisAfterTaskFinishesForReschedule;
    private final Optional<Integer> instances;
    private final Optional<Boolean> skipHealthchecks;
    private final Optional<Boolean> rackSensitive;
    private final Optional<List<String>> rackAffinity;
    private final Optional<SlavePlacement> slavePlacement;
    private final Optional<Map<String, String>> requiredSlaveAttributes;
    private final Optional<Map<String, String>> allowedSlaveAttributes;
    private final Optional<Boolean> loadBalanced;
    private final Optional<String> group;
    private final Optional<Set<String>> readOnlyGroups;
    private final Optional<Boolean> bounceAfterScale;
    private final Optional<Map<SingularityEmailType, List<SingularityEmailDestination>>> emailConfigurationOverrides;

    @JsonCreator
    public SingularityRequest(@JsonProperty(value="id") String id, @JsonProperty(value="requestType") RequestType requestType, @JsonProperty(value="owners") Optional<List<String>> owners, @JsonProperty(value="numRetriesOnFailure") Optional<Integer> numRetriesOnFailure, @JsonProperty(value="schedule") Optional<String> schedule, @JsonProperty(value="instances") Optional<Integer> instances, @JsonProperty(value="rackSensitive") Optional<Boolean> rackSensitive, @JsonProperty(value="loadBalanced") Optional<Boolean> loadBalanced, @JsonProperty(value="killOldNonLongRunningTasksAfterMillis") Optional<Long> killOldNonLongRunningTasksAfterMillis, @JsonProperty(value="scheduleType") Optional<ScheduleType> scheduleType, @JsonProperty(value="quartzSchedule") Optional<String> quartzSchedule, @JsonProperty(value="rackAffinity") Optional<List<String>> rackAffinity, @JsonProperty(value="slavePlacement") Optional<SlavePlacement> slavePlacement, @JsonProperty(value="requiredSlaveAttributes") Optional<Map<String, String>> requiredSlaveAttributes, @JsonProperty(value="allowedSlaveAttributes") Optional<Map<String, String>> allowedSlaveAttributes, @JsonProperty(value="scheduledExpectedRuntimeMillis") Optional<Long> scheduledExpectedRuntimeMillis, @JsonProperty(value="waitAtLeastMillisAfterTaskFinishesForReschedule") Optional<Long> waitAtLeastMillisAfterTaskFinishesForReschedule, @JsonProperty(value="group") Optional<String> group, @JsonProperty(value="readOnlyGroups") Optional<Set<String>> readOnlyGroups, @JsonProperty(value="bounceAfterScale") Optional<Boolean> bounceAfterScale, @JsonProperty(value="skipHealthchecks") Optional<Boolean> skipHealthchecks, @JsonProperty(value="emailConfigurationOverrides") Optional<Map<SingularityEmailType, List<SingularityEmailDestination>>> emailConfigurationOverrides, @JsonProperty(value="daemon") @Deprecated Optional<Boolean> daemon) {
        this.id = Preconditions.checkNotNull(id, "id cannot be null");
        this.owners = owners;
        this.numRetriesOnFailure = numRetriesOnFailure;
        this.schedule = schedule;
        this.rackSensitive = rackSensitive;
        this.instances = instances;
        this.loadBalanced = loadBalanced;
        this.killOldNonLongRunningTasksAfterMillis = killOldNonLongRunningTasksAfterMillis;
        this.scheduleType = scheduleType;
        this.quartzSchedule = quartzSchedule;
        this.rackAffinity = rackAffinity;
        this.slavePlacement = slavePlacement;
        this.requiredSlaveAttributes = requiredSlaveAttributes;
        this.allowedSlaveAttributes = allowedSlaveAttributes;
        this.scheduledExpectedRuntimeMillis = scheduledExpectedRuntimeMillis;
        this.waitAtLeastMillisAfterTaskFinishesForReschedule = waitAtLeastMillisAfterTaskFinishesForReschedule;
        this.group = group;
        this.readOnlyGroups = readOnlyGroups;
        this.bounceAfterScale = bounceAfterScale;
        this.emailConfigurationOverrides = emailConfigurationOverrides;
        this.skipHealthchecks = skipHealthchecks;
        this.requestType = requestType == null ? RequestType.fromDaemonAndScheduleAndLoadBalanced(schedule, daemon, loadBalanced) : requestType;
    }

    public SingularityRequestBuilder toBuilder() {
        return new SingularityRequestBuilder(this.id, this.requestType).setLoadBalanced(this.loadBalanced).setInstances(this.instances).setNumRetriesOnFailure(this.numRetriesOnFailure).setOwners(JsonHelpers.copyOfList(this.owners)).setRackSensitive(this.rackSensitive).setSchedule(this.schedule).setKillOldNonLongRunningTasksAfterMillis(this.killOldNonLongRunningTasksAfterMillis).setScheduleType(this.scheduleType).setQuartzSchedule(this.quartzSchedule).setRackAffinity(JsonHelpers.copyOfList(this.rackAffinity)).setWaitAtLeastMillisAfterTaskFinishesForReschedule(this.waitAtLeastMillisAfterTaskFinishesForReschedule).setSlavePlacement(this.slavePlacement).setRequiredSlaveAttributes(this.requiredSlaveAttributes).setAllowedSlaveAttributes(this.allowedSlaveAttributes).setScheduledExpectedRuntimeMillis(this.scheduledExpectedRuntimeMillis).setGroup(this.group).setReadOnlyGroups(this.readOnlyGroups).setBounceAfterScale(this.bounceAfterScale).setEmailConfigurationOverrides(this.emailConfigurationOverrides).setSkipHealthchecks(this.skipHealthchecks);
    }

    public String getId() {
        return this.id;
    }

    public Optional<List<String>> getOwners() {
        return this.owners;
    }

    public Optional<Integer> getNumRetriesOnFailure() {
        return this.numRetriesOnFailure;
    }

    public Optional<String> getSchedule() {
        return this.schedule;
    }

    public Optional<String> getQuartzSchedule() {
        return this.quartzSchedule;
    }

    public Optional<Integer> getInstances() {
        return this.instances;
    }

    public Optional<Boolean> getRackSensitive() {
        return this.rackSensitive;
    }

    public Optional<Boolean> getLoadBalanced() {
        return this.loadBalanced;
    }

    public RequestType getRequestType() {
        return this.requestType;
    }

    public Optional<Long> getKillOldNonLongRunningTasksAfterMillis() {
        return this.killOldNonLongRunningTasksAfterMillis;
    }

    public Optional<ScheduleType> getScheduleType() {
        return this.scheduleType;
    }

    public Optional<List<String>> getRackAffinity() {
        return this.rackAffinity;
    }

    public Optional<SlavePlacement> getSlavePlacement() {
        return this.slavePlacement;
    }

    public Optional<Long> getScheduledExpectedRuntimeMillis() {
        return this.scheduledExpectedRuntimeMillis;
    }

    public Optional<Map<String, String>> getRequiredSlaveAttributes() {
        return this.requiredSlaveAttributes;
    }

    public Optional<Map<String, String>> getAllowedSlaveAttributes() {
        return this.allowedSlaveAttributes;
    }

    @JsonIgnore
    public int getInstancesSafe() {
        return this.getInstances().or(1);
    }

    @JsonIgnore
    public boolean isScheduled() {
        return this.requestType == RequestType.SCHEDULED;
    }

    @JsonIgnore
    public String getQuartzScheduleSafe() {
        if (this.quartzSchedule.isPresent()) {
            return this.quartzSchedule.get();
        }
        return this.schedule.get();
    }

    @JsonIgnore
    public boolean isLongRunning() {
        return this.requestType.isLongRunning();
    }

    @JsonIgnore
    public boolean isAlwaysRunning() {
        return this.requestType.isAlwaysRunning();
    }

    @JsonIgnore
    public boolean isOneOff() {
        return this.requestType == RequestType.ON_DEMAND;
    }

    @JsonIgnore
    public boolean isDeployable() {
        return this.requestType.isDeployable();
    }

    @JsonIgnore
    public boolean isRackSensitive() {
        return this.rackSensitive.or(Boolean.FALSE);
    }

    @JsonIgnore
    public boolean isLoadBalanced() {
        return this.loadBalanced.or(Boolean.FALSE);
    }

    @JsonIgnore
    public ScheduleType getScheduleTypeSafe() {
        return this.scheduleType.or(ScheduleType.CRON);
    }

    public Optional<Long> getWaitAtLeastMillisAfterTaskFinishesForReschedule() {
        return this.waitAtLeastMillisAfterTaskFinishesForReschedule;
    }

    public Optional<String> getGroup() {
        return this.group;
    }

    public Optional<Set<String>> getReadOnlyGroups() {
        return this.readOnlyGroups;
    }

    public Optional<Boolean> getBounceAfterScale() {
        return this.bounceAfterScale;
    }

    public Optional<Map<SingularityEmailType, List<SingularityEmailDestination>>> getEmailConfigurationOverrides() {
        return this.emailConfigurationOverrides;
    }

    public Optional<Boolean> getSkipHealthchecks() {
        return this.skipHealthchecks;
    }

    public String toString() {
        return "SingularityRequest[id='" + this.id + '\'' + ", requestType=" + (Object)((Object)this.requestType) + ", owners=" + this.owners + ", numRetriesOnFailure=" + this.numRetriesOnFailure + ", schedule=" + this.schedule + ", quartzSchedule=" + this.quartzSchedule + ", scheduleType=" + this.scheduleType + ", killOldNonLongRunningTasksAfterMillis=" + this.killOldNonLongRunningTasksAfterMillis + ", scheduledExpectedRuntimeMillis=" + this.scheduledExpectedRuntimeMillis + ", waitAtLeastMillisAfterTaskFinishesForReschedule=" + this.waitAtLeastMillisAfterTaskFinishesForReschedule + ", instances=" + this.instances + ", rackSensitive=" + this.rackSensitive + ", rackAffinity=" + this.rackAffinity + ", slavePlacement=" + this.slavePlacement + ", requiredSlaveAttributes=" + this.requiredSlaveAttributes + ", allowedSlaveAttributes=" + this.allowedSlaveAttributes + ", loadBalanced=" + this.loadBalanced + ", group=" + this.group + ", readOnlyGroups=" + this.readOnlyGroups + ", bounceAfterScale=" + this.bounceAfterScale + ", emailConfigurationOverrides=" + this.emailConfigurationOverrides + ']';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingularityRequest request = (SingularityRequest)o;
        return Objects.equals(this.id, request.id) && Objects.equals((Object)this.requestType, (Object)request.requestType) && Objects.equals(this.owners, request.owners) && Objects.equals(this.numRetriesOnFailure, request.numRetriesOnFailure) && Objects.equals(this.schedule, request.schedule) && Objects.equals(this.quartzSchedule, request.quartzSchedule) && Objects.equals(this.scheduleType, request.scheduleType) && Objects.equals(this.killOldNonLongRunningTasksAfterMillis, request.killOldNonLongRunningTasksAfterMillis) && Objects.equals(this.scheduledExpectedRuntimeMillis, request.scheduledExpectedRuntimeMillis) && Objects.equals(this.waitAtLeastMillisAfterTaskFinishesForReschedule, request.waitAtLeastMillisAfterTaskFinishesForReschedule) && Objects.equals(this.instances, request.instances) && Objects.equals(this.rackSensitive, request.rackSensitive) && Objects.equals(this.rackAffinity, request.rackAffinity) && Objects.equals(this.slavePlacement, request.slavePlacement) && Objects.equals(this.requiredSlaveAttributes, request.requiredSlaveAttributes) && Objects.equals(this.allowedSlaveAttributes, request.allowedSlaveAttributes) && Objects.equals(this.loadBalanced, request.loadBalanced) && Objects.equals(this.group, request.group) && Objects.equals(this.readOnlyGroups, request.readOnlyGroups) && Objects.equals(this.bounceAfterScale, request.bounceAfterScale) && Objects.equals(this.emailConfigurationOverrides, request.emailConfigurationOverrides);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.requestType, this.owners, this.numRetriesOnFailure, this.schedule, this.quartzSchedule, this.scheduleType, this.killOldNonLongRunningTasksAfterMillis, this.scheduledExpectedRuntimeMillis, this.waitAtLeastMillisAfterTaskFinishesForReschedule, this.instances, this.rackSensitive, this.rackAffinity, this.slavePlacement, this.requiredSlaveAttributes, this.allowedSlaveAttributes, this.loadBalanced, this.group, this.readOnlyGroups, this.bounceAfterScale, this.emailConfigurationOverrides});
    }
}

