/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.google.common.base.Optional;
import com.google.common.collect.ListMultimap;
import com.hubspot.singularity.ExtendedTaskState;
import com.hubspot.singularity.SingularityDeployStatistics;

public class SingularityDeployStatisticsBuilder {
    private final String requestId;
    private final String deployId;
    private int numTasks;
    private int numSuccess;
    private int numFailures;
    private int numSequentialRetries;
    private ListMultimap<Integer, Long> instanceSequentialFailureTimestamps;
    private Optional<Long> lastFinishAt;
    private Optional<ExtendedTaskState> lastTaskState;
    private Optional<Long> averageRuntimeMillis;

    public SingularityDeployStatisticsBuilder(String requestId, String deployId) {
        this.requestId = requestId;
        this.deployId = deployId;
        this.lastFinishAt = Optional.absent();
        this.lastTaskState = Optional.absent();
        this.averageRuntimeMillis = Optional.absent();
    }

    public SingularityDeployStatistics build() {
        return new SingularityDeployStatistics(this.requestId, this.deployId, this.numSuccess, this.numFailures, this.numSequentialRetries, this.lastFinishAt, this.lastTaskState, this.instanceSequentialFailureTimestamps, this.numTasks, this.averageRuntimeMillis);
    }

    public ListMultimap<Integer, Long> getInstanceSequentialFailureTimestamps() {
        return this.instanceSequentialFailureTimestamps;
    }

    public SingularityDeployStatisticsBuilder setInstanceSequentialFailureTimestamps(ListMultimap<Integer, Long> instanceSequentialFailureTimestamps) {
        this.instanceSequentialFailureTimestamps = instanceSequentialFailureTimestamps;
        return this;
    }

    public int getNumSuccess() {
        return this.numSuccess;
    }

    public SingularityDeployStatisticsBuilder setNumSuccess(int numSuccess) {
        this.numSuccess = numSuccess;
        return this;
    }

    public int getNumFailures() {
        return this.numFailures;
    }

    public SingularityDeployStatisticsBuilder setNumFailures(int numFailures) {
        this.numFailures = numFailures;
        return this;
    }

    public int getNumSequentialRetries() {
        return this.numSequentialRetries;
    }

    public SingularityDeployStatisticsBuilder setNumSequentialRetries(int numSequentialRetries) {
        this.numSequentialRetries = numSequentialRetries;
        return this;
    }

    public Optional<Long> getLastFinishAt() {
        return this.lastFinishAt;
    }

    public SingularityDeployStatisticsBuilder setLastFinishAt(Optional<Long> lastFinishAt) {
        this.lastFinishAt = lastFinishAt;
        return this;
    }

    public Optional<ExtendedTaskState> getLastTaskState() {
        return this.lastTaskState;
    }

    public SingularityDeployStatisticsBuilder setLastTaskState(Optional<ExtendedTaskState> lastTaskState) {
        this.lastTaskState = lastTaskState;
        return this;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public int getNumTasks() {
        return this.numTasks;
    }

    public SingularityDeployStatisticsBuilder setNumTasks(int numTasks) {
        this.numTasks = numTasks;
        return this;
    }

    public Optional<Long> getAverageRuntimeMillis() {
        return this.averageRuntimeMillis;
    }

    public SingularityDeployStatisticsBuilder setAverageRuntimeMillis(Optional<Long> averageRuntimeMillis) {
        this.averageRuntimeMillis = averageRuntimeMillis;
        return this;
    }

    public String getDeployId() {
        return this.deployId;
    }

    public String toString() {
        return "SingularityDeployStatisticsBuilder [requestId=" + this.requestId + ", deployId=" + this.deployId + ", numTasks=" + this.numTasks + ", numSuccess=" + this.numSuccess + ", numFailures=" + this.numFailures + ", numSequentialRetries=" + this.numSequentialRetries + ", instanceSequentialFailureTimestamps=" + this.instanceSequentialFailureTimestamps + ", lastFinishAt=" + this.lastFinishAt + ", lastTaskState=" + this.lastTaskState + ", averageRuntimeMillis=" + this.averageRuntimeMillis + "]";
    }
}

