/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.collect.ComparisonChain;
import java.util.Objects;

public class SingularityDeployMarker
implements Comparable<SingularityDeployMarker> {
    private final String requestId;
    private final String deployId;
    private final long timestamp;
    private final Optional<String> user;
    private final Optional<String> message;

    @JsonCreator
    public SingularityDeployMarker(@JsonProperty(value="requestId") String requestId, @JsonProperty(value="deployId") String deployId, @JsonProperty(value="timestamp") long timestamp, @JsonProperty(value="user") Optional<String> user, @JsonProperty(value="message") Optional<String> message) {
        this.requestId = requestId;
        this.deployId = deployId;
        this.timestamp = timestamp;
        this.user = user;
        this.message = message;
    }

    @Override
    public int compareTo(SingularityDeployMarker o) {
        return ComparisonChain.start().compare(this.timestamp, o.getTimestamp()).compare((Comparable<?>)((Object)this.deployId), (Comparable<?>)((Object)o.getDeployId())).result();
    }

    public int hashCode() {
        return Objects.hash(this.requestId, this.deployId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SingularityDeployMarker other = (SingularityDeployMarker)obj;
        if (this.deployId == null ? other.deployId != null : !this.deployId.equals(other.deployId)) {
            return false;
        }
        return !(this.requestId == null ? other.requestId != null : !this.requestId.equals(other.requestId));
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getDeployId() {
        return this.deployId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Optional<String> getUser() {
        return this.user;
    }

    public Optional<String> getMessage() {
        return this.message;
    }

    public String toString() {
        return "SingularityDeployMarker [requestId=" + this.requestId + ", deployId=" + this.deployId + ", timestamp=" + this.timestamp + ", user=" + this.user + ", message=" + this.message + "]";
    }
}

