/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.mesos.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class MesosResourcesObject {
    private final ImmutableMap<String, Object> properties;

    @JsonCreator
    public MesosResourcesObject(Map<String, Object> properties) {
        this.properties = ImmutableMap.copyOf(Preconditions.checkNotNull(properties, "properties is null"));
    }

    public Optional<Integer> getNumCpus() {
        return this.getResourceAsInteger("cpus");
    }

    public Optional<Long> getDiskSpace() {
        return this.getResourceAsLong("disk");
    }

    public Optional<Integer> getMemoryMegaBytes() {
        return this.getResourceAsInteger("mem");
    }

    public Optional<String> getPorts() {
        return this.getResourceAsString("ports");
    }

    public Optional<Integer> getResourceAsInteger(String resourceName) {
        Preconditions.checkNotNull(resourceName, "resourceName is null");
        return this.properties.containsKey(resourceName) ? Optional.of(((Number)this.properties.get(resourceName)).intValue()) : Optional.absent();
    }

    public Optional<Long> getResourceAsLong(String resourceName) {
        Preconditions.checkNotNull(resourceName, "resourceName is null");
        return this.properties.containsKey(resourceName) ? Optional.of(((Number)this.properties.get(resourceName)).longValue()) : Optional.absent();
    }

    public Optional<String> getResourceAsString(String resourceName) {
        Preconditions.checkNotNull(resourceName, "resourceName is null");
        return this.properties.containsKey(resourceName) ? Optional.of(this.properties.get(resourceName).toString()) : Optional.absent();
    }

    public Optional<Object> getResourceAsObject(String resourceName) {
        Preconditions.checkNotNull(resourceName, "resourceName is null");
        return Optional.fromNullable(this.properties.get(resourceName));
    }
}

