/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.mesos;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.mesos.SingularityDockerNetworkType;
import com.hubspot.mesos.SingularityDockerPortMapping;
import com.hubspot.mesos.SingularityPortMappingType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class SingularityDockerInfo {
    private final String image;
    private final boolean privileged;
    private final Optional<SingularityDockerNetworkType> network;
    private final List<SingularityDockerPortMapping> portMappings;
    private final boolean forcePullImage;
    private final Map<String, String> parameters;

    @JsonCreator
    public SingularityDockerInfo(@JsonProperty(value="image") String image, @JsonProperty(value="privileged") boolean privileged, @JsonProperty(value="network") SingularityDockerNetworkType network, @JsonProperty(value="portMappings") Optional<List<SingularityDockerPortMapping>> portMappings, @JsonProperty(value="forcePullImage") Optional<Boolean> forcePullImage, @JsonProperty(value="parameters") Optional<Map<String, String>> parameters) {
        this.image = image;
        this.privileged = privileged;
        this.network = Optional.fromNullable(network);
        this.portMappings = portMappings.or(Collections.emptyList());
        this.forcePullImage = forcePullImage.or(false);
        this.parameters = parameters.or(Collections.emptyMap());
    }

    @Deprecated
    public SingularityDockerInfo(String image, boolean privileged, SingularityDockerNetworkType network, Optional<List<SingularityDockerPortMapping>> portMappings) {
        this(image, privileged, network, portMappings, Optional.absent(), Optional.absent());
    }

    public String getImage() {
        return this.image;
    }

    public boolean isPrivileged() {
        return this.privileged;
    }

    public Optional<SingularityDockerNetworkType> getNetwork() {
        return this.network;
    }

    public List<SingularityDockerPortMapping> getPortMappings() {
        return this.portMappings;
    }

    public boolean hasAllLiteralHostPortMappings() {
        for (SingularityDockerPortMapping mapping : this.portMappings) {
            if (mapping.getHostPortType() != SingularityPortMappingType.FROM_OFFER) continue;
            return false;
        }
        return true;
    }

    @JsonIgnore
    public List<Long> getLiteralHostPorts() {
        ArrayList<Long> literalHostPorts = new ArrayList<Long>();
        for (SingularityDockerPortMapping mapping : this.portMappings) {
            if (mapping.getHostPortType() != SingularityPortMappingType.LITERAL) continue;
            long port = mapping.getHostPort();
            literalHostPorts.add(port);
        }
        return literalHostPorts;
    }

    public boolean isForcePullImage() {
        return this.forcePullImage;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String toString() {
        return "SingularityDockerInfo{image='" + this.image + '\'' + ", privileged=" + this.privileged + ", network=" + this.network + ", portMappings=" + this.portMappings + ", forcePullImage=" + this.forcePullImage + ", parameters=" + this.parameters + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingularityDockerInfo that = (SingularityDockerInfo)o;
        if (this.forcePullImage != that.forcePullImage) {
            return false;
        }
        if (this.privileged != that.privileged) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.network != null ? !this.network.equals(that.network) : that.network != null) {
            return false;
        }
        if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) {
            return false;
        }
        return !(this.portMappings != null ? !this.portMappings.equals(that.portMappings) : that.portMappings != null);
    }

    public int hashCode() {
        int result = this.image != null ? this.image.hashCode() : 0;
        result = 31 * result + (this.privileged ? 1 : 0);
        result = 31 * result + (this.network != null ? this.network.hashCode() : 0);
        result = 31 * result + (this.portMappings != null ? this.portMappings.hashCode() : 0);
        result = 31 * result + (this.forcePullImage ? 1 : 0);
        result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
        return result;
    }
}

