/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.mesos;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.mesos.SingularityContainerType;
import com.hubspot.mesos.SingularityDockerInfo;
import com.hubspot.mesos.SingularityVolume;
import java.util.List;
import org.apache.mesos.Protos;

public class SingularityContainerInfo {
    private final SingularityContainerType type;
    private final Optional<List<SingularityVolume>> volumes;
    private final Optional<SingularityDockerInfo> docker;

    @JsonCreator
    public SingularityContainerInfo(@JsonProperty(value="type") SingularityContainerType type, @JsonProperty(value="volumes") Optional<List<SingularityVolume>> volumes, @JsonProperty(value="docker") Optional<SingularityDockerInfo> docker) {
        this.type = type;
        this.volumes = volumes;
        this.docker = docker;
    }

    @Deprecated
    public SingularityContainerInfo(Protos.ContainerInfo.Type type, Optional<List<SingularityVolume>> volumes, Optional<SingularityDockerInfo> docker) {
        this(SingularityContainerType.valueOf(type.toString()), volumes, docker);
    }

    public SingularityContainerType getType() {
        return this.type;
    }

    public Optional<List<SingularityVolume>> getVolumes() {
        return this.volumes;
    }

    public Optional<SingularityDockerInfo> getDocker() {
        return this.docker;
    }

    public String toString() {
        return String.format("ContainerInfo [type=%s, volumes=%s, docker=%s]", new Object[]{this.type, this.volumes, this.docker});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingularityContainerInfo that = (SingularityContainerInfo)o;
        if (!this.type.equals((Object)that.type)) {
            return false;
        }
        if (!this.volumes.equals(that.volumes)) {
            return false;
        }
        return this.docker.equals(that.docker);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.volumes.hashCode();
        result = 31 * result + this.docker.hashCode();
        return result;
    }
}

