/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.deploy;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.deploy.RemoteArtifact;

public class S3Artifact
extends RemoteArtifact {
    private final String s3Bucket;
    private final String s3ObjectKey;

    @JsonCreator
    public S3Artifact(@JsonProperty(value="name") String name, @JsonProperty(value="filename") String filename, @JsonProperty(value="md5sum") Optional<String> md5sum, @JsonProperty(value="filesize") Optional<Long> filesize, @JsonProperty(value="s3Bucket") String s3Bucket, @JsonProperty(value="s3ObjectKey") String s3ObjectKey) {
        super(name, filename, md5sum, filesize);
        this.s3Bucket = s3Bucket;
        this.s3ObjectKey = s3ObjectKey;
    }

    public String getS3Bucket() {
        return this.s3Bucket;
    }

    public String getS3ObjectKey() {
        return this.s3ObjectKey;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.s3Bucket == null ? 0 : this.s3Bucket.hashCode());
        result = 31 * result + (this.s3ObjectKey == null ? 0 : this.s3ObjectKey.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        S3Artifact other = (S3Artifact)obj;
        if (this.s3Bucket == null ? other.s3Bucket != null : !this.s3Bucket.equals(other.s3Bucket)) {
            return false;
        }
        return !(this.s3ObjectKey == null ? other.s3ObjectKey != null : !this.s3ObjectKey.equals(other.s3ObjectKey));
    }

    @Override
    public String toString() {
        return "S3Artifact [s3Bucket=" + this.s3Bucket + ", s3ObjectKey=" + this.s3ObjectKey + ", getFilesize()=" + this.getFilesize() + ", getName()=" + this.getName() + ", getFilename()=" + this.getFilename() + ", getMd5sum()=" + this.getMd5sum() + "]";
    }
}

