/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.baragon.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BaragonService {
    @NotNull
    @Pattern(regexp="[^\\s/|]+", message="cannot contain whitespace, '/', or '|'", flags={Pattern.Flag.MULTILINE})
    private final String serviceId;
    @NotNull
    private final Collection<String> owners;
    @NotNull
    @Pattern(regexp="/(?:[A-Za-z0-9\\-._~!$&'()*+,;=:@/?]|%[0-9A-Fa-f]{2})*", message="must be an absolute URL path")
    private final String serviceBasePath;
    @NotNull
    @Size(min=1)
    private final Set<String> loadBalancerGroups;
    private final Map<String, Object> options;
    private final Optional<String> templateName;

    public BaragonService(@JsonProperty(value="serviceId") String serviceId, @JsonProperty(value="owners") Collection<String> owners, @JsonProperty(value="serviceBasePath") String serviceBasePath, @JsonProperty(value="loadBalancerGroups") Set<String> loadBalancerGroups, @JsonProperty(value="options") Map<String, Object> options, @JsonProperty(value="templateName") Optional<String> templateName) {
        this.serviceId = serviceId;
        this.owners = owners;
        this.serviceBasePath = serviceBasePath;
        this.loadBalancerGroups = loadBalancerGroups;
        this.options = options;
        this.templateName = templateName;
    }

    public BaragonService(String serviceId, Collection<String> owners, String serviceBasePath, Set<String> loadBalancerGroups, Map<String, Object> options) {
        this(serviceId, owners, serviceBasePath, loadBalancerGroups, options, Optional.absent());
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public Collection<String> getOwners() {
        return this.owners;
    }

    public String getServiceBasePath() {
        return this.serviceBasePath;
    }

    public Set<String> getLoadBalancerGroups() {
        return this.loadBalancerGroups;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public Optional<String> getTemplateName() {
        return this.templateName;
    }

    public String toString() {
        return "BaragonService [serviceId='" + this.serviceId + '\'' + ", owners=" + this.owners + ", serviceBasePath='" + this.serviceBasePath + '\'' + ", loadBalancerGroups=" + this.loadBalancerGroups + ", options=" + this.options + ", templateName=" + this.templateName + ']';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaragonService service = (BaragonService)o;
        if (this.loadBalancerGroups != null ? !this.loadBalancerGroups.equals(service.loadBalancerGroups) : service.loadBalancerGroups != null) {
            return false;
        }
        if (this.options != null ? !this.options.equals(service.options) : service.options != null) {
            return false;
        }
        if (this.owners != null ? !this.owners.equals(service.owners) : service.owners != null) {
            return false;
        }
        if (this.serviceBasePath != null ? !this.serviceBasePath.equals(service.serviceBasePath) : service.serviceBasePath != null) {
            return false;
        }
        if (this.serviceId != null ? !this.serviceId.equals(service.serviceId) : service.serviceId != null) {
            return false;
        }
        return !(this.templateName != null ? !this.templateName.equals(service.templateName) : service.templateName != null);
    }

    public int hashCode() {
        int result = this.serviceId != null ? this.serviceId.hashCode() : 0;
        result = 31 * result + (this.owners != null ? this.owners.hashCode() : 0);
        result = 31 * result + (this.serviceBasePath != null ? this.serviceBasePath.hashCode() : 0);
        result = 31 * result + (this.loadBalancerGroups != null ? this.loadBalancerGroups.hashCode() : 0);
        result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
        result = 31 * result + (this.templateName != null ? this.templateName.hashCode() : 0);
        return result;
    }
}

