/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.baragon.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.baragon.models.AgentResponse;
import com.hubspot.baragon.models.BaragonRequestState;
import java.util.Collection;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BaragonResponse {
    private final String loadBalancerRequestId;
    private final BaragonRequestState loadBalancerState;
    private final Optional<String> message;
    private final Optional<Map<String, Collection<AgentResponse>>> agentResponses;

    public static BaragonResponse failure(String requestId, String message) {
        return new BaragonResponse(requestId, BaragonRequestState.FAILED, Optional.fromNullable(message), Optional.absent());
    }

    public static BaragonResponse requestDoesNotExist(String requestId) {
        return new BaragonResponse(requestId, BaragonRequestState.CANCELED, Optional.of(String.format("Request %s does not exist", requestId)), Optional.absent());
    }

    public static BaragonResponse serviceNotFound(String requestId, String serviceId) {
        return new BaragonResponse(requestId, BaragonRequestState.INVALID_REQUEST_NOOP, Optional.of(String.format("Service %s not found", serviceId)), Optional.absent());
    }

    @JsonCreator
    public BaragonResponse(@JsonProperty(value="loadBalancerRequestId") String loadBalancerRequestId, @JsonProperty(value="loadBalancerState") BaragonRequestState loadBalancerState, @JsonProperty(value="message") Optional<String> message, @JsonProperty(value="agentResponses") Optional<Map<String, Collection<AgentResponse>>> agentResponses) {
        this.loadBalancerRequestId = loadBalancerRequestId;
        this.loadBalancerState = loadBalancerState;
        this.message = message;
        this.agentResponses = agentResponses;
    }

    public String getLoadBalancerRequestId() {
        return this.loadBalancerRequestId;
    }

    public BaragonRequestState getLoadBalancerState() {
        return this.loadBalancerState;
    }

    public Optional<String> getMessage() {
        return this.message;
    }

    public Optional<Map<String, Collection<AgentResponse>>> getAgentResponses() {
        return this.agentResponses;
    }

    public String toString() {
        return "BaragonResponse [loadBalancerRequestId='" + this.loadBalancerRequestId + '\'' + ", loadBalancerState=" + (Object)((Object)this.loadBalancerState) + ", message=" + this.message + ", agentResponses=" + this.agentResponses + ']';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaragonResponse that = (BaragonResponse)o;
        if (!this.agentResponses.equals(that.agentResponses)) {
            return false;
        }
        if (!this.loadBalancerRequestId.equals(that.loadBalancerRequestId)) {
            return false;
        }
        if (this.loadBalancerState != that.loadBalancerState) {
            return false;
        }
        return this.message.equals(that.message);
    }

    public int hashCode() {
        int result = this.loadBalancerRequestId.hashCode();
        result = 31 * result + this.loadBalancerState.hashCode();
        result = 31 * result + this.message.hashCode();
        result = 31 * result + this.agentResponses.hashCode();
        return result;
    }
}

