/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.context;

import com.github.jknack.handlebars.ValueResolver;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.Validate;

public abstract class MemberValueResolver<M extends Member>
implements ValueResolver {
    private final Map<String, Object> cache = new ConcurrentHashMap<String, Object>();

    @Override
    public final Object resolve(Object context, String name) {
        String key = this.key(context, name);
        Object value = this.cache.get(key);
        if (value == UNRESOLVED) {
            return value;
        }
        Member member = (Member)value;
        if (member == null) {
            member = this.find(context.getClass(), name);
            if (member == null) {
                this.cache.put(key, UNRESOLVED);
                return UNRESOLVED;
            }
            if (member instanceof AccessibleObject) {
                ((AccessibleObject)((Object)member)).setAccessible(true);
            }
            this.cache.put(key, member);
        }
        return this.invokeMember(member, context);
    }

    @Override
    public Object resolve(Object context) {
        return UNRESOLVED;
    }

    protected final M find(Class<?> clazz, String name) {
        Set<M> members = this.membersFromCache(clazz);
        for (Member member : members) {
            if (!this.matches(member, name)) continue;
            return (M)member;
        }
        return null;
    }

    protected abstract Object invokeMember(M var1, Object var2);

    public abstract boolean matches(M var1, String var2);

    protected boolean isPublic(M member) {
        return Modifier.isPublic(member.getModifiers());
    }

    protected boolean isPrivate(M member) {
        return Modifier.isPrivate(member.getModifiers());
    }

    protected boolean isProtected(M member) {
        return Modifier.isProtected(member.getModifiers());
    }

    protected boolean isStatic(M member) {
        return Modifier.isStatic(member.getModifiers());
    }

    private String key(Object context, String name) {
        return context.getClass().getName() + "#" + name;
    }

    protected abstract Set<M> members(Class<?> var1);

    protected Set<M> membersFromCache(Class<?> clazz) {
        String key = clazz.getName();
        Set<M> members = (Set<M>)this.cache.get(key);
        if (members == null) {
            members = this.members(clazz);
            this.cache.put(key, members);
        }
        return members;
    }

    @Override
    public Set<Map.Entry<String, Object>> propertySet(Object context) {
        Validate.notNull(context, "The context is required.", new Object[0]);
        if (context instanceof Map) {
            return Collections.emptySet();
        }
        if (context instanceof Collection) {
            return Collections.emptySet();
        }
        Set<M> members = this.membersFromCache(context.getClass());
        LinkedHashMap<String, Object> propertySet = new LinkedHashMap<String, Object>();
        for (Member member : members) {
            String name = this.memberName(member);
            propertySet.put(name, this.resolve(context, name));
        }
        return propertySet.entrySet();
    }

    protected abstract String memberName(M var1);
}

