/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class Slf4jReporter
extends ScheduledReporter {
    private final Logger logger;
    private final Marker marker;

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    private Slf4jReporter(MetricRegistry registry, Logger logger2, Marker marker, TimeUnit rateUnit, TimeUnit durationUnit, MetricFilter filter) {
        super(registry, "logger-reporter", filter, rateUnit, durationUnit);
        this.logger = logger2;
        this.marker = marker;
    }

    @Override
    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
            this.logGauge(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Metric> entry : counters.entrySet()) {
            this.logCounter(entry.getKey(), (Counter)entry.getValue());
        }
        for (Map.Entry<String, Metric> entry : histograms.entrySet()) {
            this.logHistogram(entry.getKey(), (Histogram)entry.getValue());
        }
        for (Map.Entry<String, Metric> entry : meters.entrySet()) {
            this.logMeter(entry.getKey(), (Meter)entry.getValue());
        }
        for (Map.Entry<String, Metric> entry : timers.entrySet()) {
            this.logTimer(entry.getKey(), (Timer)entry.getValue());
        }
    }

    private void logTimer(String name, Timer timer) {
        Snapshot snapshot = timer.getSnapshot();
        this.logger.info(this.marker, "type=TIMER, name={}, count={}, min={}, max={}, mean={}, stddev={}, median={}, p75={}, p95={}, p98={}, p99={}, p999={}, mean_rate={}, m1={}, m5={}, m15={}, rate_unit={}, duration_unit={}", name, timer.getCount(), this.convertDuration(snapshot.getMin()), this.convertDuration(snapshot.getMax()), this.convertDuration(snapshot.getMean()), this.convertDuration(snapshot.getStdDev()), this.convertDuration(snapshot.getMedian()), this.convertDuration(snapshot.get75thPercentile()), this.convertDuration(snapshot.get95thPercentile()), this.convertDuration(snapshot.get98thPercentile()), this.convertDuration(snapshot.get99thPercentile()), this.convertDuration(snapshot.get999thPercentile()), this.convertRate(timer.getMeanRate()), this.convertRate(timer.getOneMinuteRate()), this.convertRate(timer.getFiveMinuteRate()), this.convertRate(timer.getFifteenMinuteRate()), this.getRateUnit(), this.getDurationUnit());
    }

    private void logMeter(String name, Meter meter) {
        this.logger.info(this.marker, "type=METER, name={}, count={}, mean_rate={}, m1={}, m5={}, m15={}, rate_unit={}", name, meter.getCount(), this.convertRate(meter.getMeanRate()), this.convertRate(meter.getOneMinuteRate()), this.convertRate(meter.getFiveMinuteRate()), this.convertRate(meter.getFifteenMinuteRate()), this.getRateUnit());
    }

    private void logHistogram(String name, Histogram histogram) {
        Snapshot snapshot = histogram.getSnapshot();
        this.logger.info(this.marker, "type=HISTOGRAM, name={}, count={}, min={}, max={}, mean={}, stddev={}, median={}, p75={}, p95={}, p98={}, p99={}, p999={}", name, histogram.getCount(), snapshot.getMin(), snapshot.getMax(), snapshot.getMean(), snapshot.getStdDev(), snapshot.getMedian(), snapshot.get75thPercentile(), snapshot.get95thPercentile(), snapshot.get98thPercentile(), snapshot.get99thPercentile(), snapshot.get999thPercentile());
    }

    private void logCounter(String name, Counter counter) {
        this.logger.info(this.marker, "type=COUNTER, name={}, count={}", (Object)name, (Object)counter.getCount());
    }

    private void logGauge(String name, Gauge gauge) {
        this.logger.info(this.marker, "type=GAUGE, name={}, value={}", (Object)name, gauge.getValue());
    }

    @Override
    protected String getRateUnit() {
        return "events/" + super.getRateUnit();
    }

    public static class Builder {
        private final MetricRegistry registry;
        private Logger logger;
        private Marker marker;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private MetricFilter filter;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.logger = LoggerFactory.getLogger("metrics");
            this.marker = null;
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.filter = MetricFilter.ALL;
        }

        public Builder outputTo(Logger logger2) {
            this.logger = logger2;
            return this;
        }

        public Builder markWith(Marker marker) {
            this.marker = marker;
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public Slf4jReporter build() {
            return new Slf4jReporter(this.registry, this.logger, this.marker, this.rateUnit, this.durationUnit, this.filter);
        }
    }
}

