/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor;

import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.hubspot.mesos.JavaUtils;
import com.hubspot.singularity.executor.config.SingularityExecutorConfiguration;
import com.hubspot.singularity.executor.task.SingularityExecutorTaskProcessCallable;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SingularityExecutorProcessKiller {
    private static final Logger LOG = LoggerFactory.getLogger(SingularityExecutorProcessKiller.class);
    private final SingularityExecutorConfiguration configuration;
    private final ScheduledExecutorService scheduledExecutorService;
    private final Map<String, ScheduledFuture<?>> destroyFutures;

    @Inject
    public SingularityExecutorProcessKiller(SingularityExecutorConfiguration configuration) {
        this.configuration = configuration;
        this.destroyFutures = Maps.newConcurrentMap();
        this.scheduledExecutorService = Executors.newScheduledThreadPool(configuration.getKillThreads(), new ThreadFactoryBuilder().setNameFormat("SingularityExecutorKillThread-%d").build());
    }

    public void submitKillRequest(final SingularityExecutorTaskProcessCallable processCallable) {
        final long start = System.currentTimeMillis();
        this.destroyFutures.put(processCallable.getTask().getTaskId(), this.scheduledExecutorService.schedule(new Runnable(){

            @Override
            public void run() {
                LOG.info("Killing (-9) process {} ({}) after waiting {} (max: {})", new Object[]{processCallable.getTask().getTaskId(), processCallable.getCurrentPid(), JavaUtils.duration((long)start), JavaUtils.durationFromMillis((long)SingularityExecutorProcessKiller.this.configuration.getHardKillAfterMillis())});
                processCallable.getTask().markDestroyedAfterWaiting();
                processCallable.signalKillToProcessIfActive();
            }
        }, (long)((Long)processCallable.getTask().getExecutorData().getSigKillProcessesAfterMillis().or((Object)this.configuration.getHardKillAfterMillis())), TimeUnit.MILLISECONDS));
        LOG.info("Signaling -15 to process {} ({})", (Object)processCallable.getTask().getTaskId(), (Object)processCallable.getCurrentPid());
        processCallable.markKilled();
        processCallable.signalTermToProcessIfActive();
    }

    public void cancelDestroyFuture(String taskId) {
        ScheduledFuture<?> future = this.destroyFutures.remove(taskId);
        if (future != null) {
            boolean canceled = future.cancel(false);
            LOG.info("Canceled kill future for {} - {}", (Object)taskId, (Object)canceled);
        } else {
            LOG.info("No kill future to cancel for {} ({} futures)", (Object)taskId, (Object)this.destroyFutures.size());
        }
    }

    public ExecutorService getExecutorService() {
        return this.scheduledExecutorService;
    }
}

