/*
 * Decompiled with CFR 0.152.
 */
package net.kencochrane.raven;

import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;
import net.kencochrane.raven.Raven;
import net.kencochrane.raven.dsn.Dsn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RavenFactory {
    private static final ServiceLoader<RavenFactory> AUTO_REGISTERED_FACTORIES = ServiceLoader.load(RavenFactory.class);
    private static final Set<RavenFactory> MANUALLY_REGISTERED_FACTORIES = new HashSet<RavenFactory>();
    private static final Logger logger = LoggerFactory.getLogger(RavenFactory.class);

    public static void registerFactory(RavenFactory ravenFactory) {
        MANUALLY_REGISTERED_FACTORIES.add(ravenFactory);
    }

    private static Iterable<RavenFactory> getRegisteredFactories() {
        return Iterables.concat(MANUALLY_REGISTERED_FACTORIES, AUTO_REGISTERED_FACTORIES);
    }

    public static Raven ravenInstance() {
        return RavenFactory.ravenInstance(Dsn.dsnLookup());
    }

    public static Raven ravenInstance(String dsn) {
        return RavenFactory.ravenInstance(new Dsn(dsn));
    }

    public static Raven ravenInstance(Dsn dsn) {
        return RavenFactory.ravenInstance(dsn, null);
    }

    public static Raven ravenInstance(Dsn dsn, String ravenFactoryName) {
        logger.debug("Attempting to find a working Raven factory");
        for (RavenFactory ravenFactory : RavenFactory.getRegisteredFactories()) {
            if (ravenFactoryName != null && !ravenFactoryName.equals(ravenFactory.getClass().getName())) continue;
            logger.debug("Attempting to use '{}' as a Raven factory.", (Object)ravenFactory);
            try {
                Raven ravenInstance = ravenFactory.createRavenInstance(dsn);
                logger.debug("The raven factory '{}' created an instance of Raven.", (Object)ravenFactory);
                return ravenInstance;
            }
            catch (RuntimeException e) {
                logger.debug("The raven factory '{}' couldn't create an instance of Raven.", (Object)ravenFactory, (Object)e);
            }
        }
        throw new IllegalStateException("Couldn't create a raven instance for '" + dsn + "'");
    }

    public abstract Raven createRavenInstance(Dsn var1);

    public String toString() {
        return "RavenFactory{name='" + this.getClass().getName() + '\'' + '}';
    }
}

