/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.runner.base.sentry;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.hubspot.singularity.runner.base.configuration.SingularityRunnerBaseConfiguration;
import java.util.Map;
import net.kencochrane.raven.Raven;
import net.kencochrane.raven.RavenFactory;
import net.kencochrane.raven.event.Event;
import net.kencochrane.raven.event.EventBuilder;
import net.kencochrane.raven.event.interfaces.ExceptionInterface;

@Singleton
public class SingularityRunnerExceptionNotifier {
    private final Optional<Raven> raven;
    private final SingularityRunnerBaseConfiguration configuration;

    @Inject
    public SingularityRunnerExceptionNotifier(SingularityRunnerBaseConfiguration configuration) {
        this.configuration = configuration;
        this.raven = configuration.getSentryDsn().isPresent() ? Optional.of(RavenFactory.ravenInstance(configuration.getSentryDsn().get())) : Optional.absent();
    }

    private String getPrefix() {
        if (Strings.isNullOrEmpty(this.configuration.getSentryPrefix())) {
            return "";
        }
        return this.configuration.getSentryPrefix() + " ";
    }

    private String getCallingClassName(StackTraceElement[] stackTrace) {
        if (stackTrace != null && stackTrace.length > 2) {
            return stackTrace[2].getClassName();
        }
        return "(unknown)";
    }

    private void sendEvent(Raven raven, EventBuilder eventBuilder) {
        raven.runBuilderHelpers(eventBuilder);
        raven.sendEvent(eventBuilder.build());
    }

    public void notify(Throwable t, Map<String, String> extraData) {
        if (!this.raven.isPresent()) {
            return;
        }
        StackTraceElement[] currentThreadStackTrace = Thread.currentThread().getStackTrace();
        EventBuilder eventBuilder = new EventBuilder().setCulprit(this.getPrefix() + t.getMessage()).setMessage(Strings.nullToEmpty(t.getMessage())).setLevel(Event.Level.ERROR).setLogger(this.getCallingClassName(currentThreadStackTrace)).addSentryInterface(new ExceptionInterface(t));
        if (extraData != null && !extraData.isEmpty()) {
            for (Map.Entry<String, String> entry : extraData.entrySet()) {
                eventBuilder.addExtra(entry.getKey(), entry.getValue());
            }
        }
        this.sendEvent(this.raven.get(), eventBuilder);
    }

    public void notify(String subject, Map<String, String> extraData) {
        if (!this.raven.isPresent()) {
            return;
        }
        StackTraceElement[] currentThreadStackTrace = Thread.currentThread().getStackTrace();
        EventBuilder eventBuilder = new EventBuilder().setMessage(this.getPrefix() + subject).setLevel(Event.Level.ERROR).setLogger(this.getCallingClassName(currentThreadStackTrace));
        if (extraData != null && !extraData.isEmpty()) {
            for (Map.Entry<String, String> entry : extraData.entrySet()) {
                eventBuilder.addExtra(entry.getKey(), entry.getValue());
            }
        }
        this.sendEvent(this.raven.get(), eventBuilder);
    }
}

