/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.runner.base.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.google.common.base.Optional;
import com.hubspot.mesos.JavaUtils;
import com.hubspot.singularity.runner.base.jackson.Obfuscate;
import java.io.IOException;

public class ObfuscateAnnotationIntrospector
extends AnnotationIntrospector {
    private static final long serialVersionUID = 1L;
    private static final ObfuscateSerializer OBFUSCATE_SERIALIZER = new ObfuscateSerializer();

    @Override
    public Version version() {
        return Version.unknownVersion();
    }

    @Override
    public Object findSerializer(Annotated am) {
        if (am.hasAnnotation(Obfuscate.class)) {
            return OBFUSCATE_SERIALIZER;
        }
        return null;
    }

    public static class ObfuscateSerializer
    extends JsonSerializer<Object> {
        @Override
        public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            if (value instanceof Optional) {
                if (((Optional)value).isPresent()) {
                    jgen.writeString(JavaUtils.obfuscateValue(((Optional)value).get().toString()));
                } else {
                    jgen.writeNull();
                }
            } else {
                jgen.writeString(JavaUtils.obfuscateValue(value.toString()));
            }
        }
    }
}

