/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Stage;
import com.google.inject.name.Named;
import com.hubspot.mesos.JavaUtils;
import com.hubspot.singularity.executor.SingularityExecutor;
import com.hubspot.singularity.executor.SingularityExecutorMonitor;
import com.hubspot.singularity.executor.config.SingularityExecutorConfiguration;
import com.hubspot.singularity.executor.config.SingularityExecutorModule;
import com.hubspot.singularity.runner.base.config.SingularityRunnerBaseModule;
import com.hubspot.singularity.s3.base.config.SingularityS3Configuration;
import org.apache.mesos.MesosExecutorDriver;
import org.apache.mesos.Protos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingularityExecutorRunner {
    private static final Logger LOG = LoggerFactory.getLogger(SingularityExecutorRunner.class);
    private final String name;
    private final SingularityExecutor singularityExecutor;
    private final SingularityExecutorMonitor monitor;

    public static void main(String ... args) {
        long start = System.currentTimeMillis();
        try {
            Injector injector = Guice.createInjector(Stage.PRODUCTION, new SingularityRunnerBaseModule(SingularityExecutorConfiguration.class, ImmutableSet.of(SingularityS3Configuration.class)), new SingularityExecutorModule());
            SingularityExecutorRunner executorRunner = injector.getInstance(SingularityExecutorRunner.class);
            Protos.Status driverStatus = executorRunner.run();
            LOG.info("Executor finished after {} with status: {}", (Object)JavaUtils.duration(start), (Object)driverStatus);
            System.exit(driverStatus == Protos.Status.DRIVER_STOPPED ? 0 : 1);
        }
        catch (Throwable t) {
            LOG.error("Finished after {} with error", (Object)JavaUtils.duration(start), (Object)t);
            System.exit(1);
        }
    }

    @Inject
    public SingularityExecutorRunner(@Named(value="process.name") String name, SingularityExecutor singularityExecutor, SingularityExecutorMonitor monitor) {
        this.name = name;
        this.singularityExecutor = singularityExecutor;
        this.monitor = monitor;
    }

    public Protos.Status run() {
        LOG.info("{} starting MesosExecutorDriver...", (Object)this.name);
        final MesosExecutorDriver driver = new MesosExecutorDriver(this.singularityExecutor);
        Runtime.getRuntime().addShutdownHook(new Thread("SingularityExecutorRunnerGracefulShutdown"){

            @Override
            public void run() {
                LOG.info("Executor is shutting down, ensuring shutdown via shutdown hook");
                SingularityExecutorRunner.this.monitor.shutdown(Optional.of(driver));
            }
        });
        return driver.run();
    }
}

