/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import java.util.List;

public class SingularityPendingRequest {
    private final String requestId;
    private final String deployId;
    private final long timestamp;
    private final PendingType pendingType;
    private final Optional<String> user;
    private final Optional<List<String>> cmdLineArgsList;
    private final Optional<String> runId;
    private final Optional<Boolean> skipHealthchecks;
    private final Optional<String> message;
    private final Optional<String> actionId;

    public SingularityPendingRequest(String requestId, String deployId, long timestamp, Optional<String> user, PendingType pendingType, Optional<Boolean> skipHealthchecks, Optional<String> message) {
        this(requestId, deployId, timestamp, user, pendingType, Optional.absent(), Optional.absent(), skipHealthchecks, message, Optional.absent());
    }

    @JsonCreator
    public SingularityPendingRequest(@JsonProperty(value="requestId") String requestId, @JsonProperty(value="deployId") String deployId, @JsonProperty(value="timestamp") long timestamp, @JsonProperty(value="user") Optional<String> user, @JsonProperty(value="pendingType") PendingType pendingType, @JsonProperty(value="cmdLineArgsList") Optional<List<String>> cmdLineArgsList, @JsonProperty(value="runId") Optional<String> runId, @JsonProperty(value="skipHealthchecks") Optional<Boolean> skipHealthchecks, @JsonProperty(value="message") Optional<String> message, @JsonProperty(value="actionId") Optional<String> actionId) {
        this.requestId = requestId;
        this.deployId = deployId;
        this.timestamp = timestamp;
        this.user = user;
        this.cmdLineArgsList = cmdLineArgsList;
        this.pendingType = pendingType;
        this.runId = runId;
        this.skipHealthchecks = skipHealthchecks;
        this.message = message;
        this.actionId = actionId;
    }

    public Optional<String> getActionId() {
        return this.actionId;
    }

    public Optional<String> getRunId() {
        return this.runId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getDeployId() {
        return this.deployId;
    }

    public Optional<String> getUser() {
        return this.user;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public PendingType getPendingType() {
        return this.pendingType;
    }

    public Optional<List<String>> getCmdLineArgsList() {
        return this.cmdLineArgsList;
    }

    public Optional<Boolean> getSkipHealthchecks() {
        return this.skipHealthchecks;
    }

    public Optional<String> getMessage() {
        return this.message;
    }

    public String toString() {
        return "SingularityPendingRequest [requestId=" + this.requestId + ", deployId=" + this.deployId + ", timestamp=" + this.timestamp + ", pendingType=" + (Object)((Object)this.pendingType) + ", user=" + this.user + ", cmdLineArgsList=" + this.cmdLineArgsList + ", runId=" + this.runId + ", skipHealthchecks=" + this.skipHealthchecks + ", message=" + this.message + ", actionId=" + this.actionId + "]";
    }

    public static enum PendingType {
        IMMEDIATE,
        ONEOFF,
        BOUNCE,
        NEW_DEPLOY,
        UNPAUSED,
        RETRY,
        UPDATED_REQUEST,
        DECOMISSIONED_SLAVE_OR_RACK,
        TASK_DONE,
        STARTUP,
        CANCEL_BOUNCE,
        TASK_BOUNCE;

    }
}

